/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste de clients
 */

package org.opensi.facturation.actions.editions;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;

public class GenListeClients extends Action {

	public boolean serverSide() { return true; }
	
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		String fichierPdf = r.getParameter("FichierPdf") != null ? r.getParameter("FichierPdf") : "";
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String clientId = r.getParameter("Client_Id") != null ? r.getParameter("Client_Id") : "";
		boolean clientSpecifique = (!clientId.equals(""));
		
		int familleClient = clientSpecifique?0:Integer.parseInt(r.getParameter("Famille"));
		String commercial = clientSpecifique?"":r.getParameter("Commercial");
		String tri1 = clientSpecifique?"Client_Id":r.getParameter("Tri1");
		String tri2 = clientSpecifique?"":r.getParameter("Tri2");
		String tri3 = clientSpecifique?"":r.getParameter("Tri3");
		String tarifsSpe = clientSpecifique?"0":r.getParameter("Tarifs_Spe");
		
		DataListeClients dlc = new DataListeClients(s, familleClient, commercial, tri1, tri2, tri3, tarifsSpe, clientId);
		
		if (!fichierPdf.equals("")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
		
			PdfListeClients pdfListeClients = new PdfListeClients(repTemp, dlc);			
			GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);	
			gd.addInternal(pdfListeClients);	
			gd.close(GlobalDocument.ON_EXIT);
		} else if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvListeClients(buffer, fichierCsv, dlc);
		}
		
		return true;
	}

} // fin GenListeClients
