/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration de l'tat des stocks
 */

package org.opensi.facturation.actions.editions;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;
import org.opensi.util.tools.DateTime;


public class GenEtatStock extends Action {

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String fichierPdf = r.getParameter("FichierPdf") != null ? r.getParameter("FichierPdf") : "";
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		int famille1 = Integer.parseInt(r.getParameter("Famille_1"));
		int famille2 = Integer.parseInt(r.getParameter("Famille_2"));
		int famille3 = Integer.parseInt(r.getParameter("Famille_3"));
		int marque = Integer.parseInt(r.getParameter("Marque"));
		String valorisation = r.getParameter("valorisation");
		boolean stockEntier = r.getParameter("StockEntier").equals("1");
		
		long dateArrete = 0;
		if (!r.getParameter("Date_Arrete").equals("")) { dateArrete = DateTime.parseDate(r.getParameter("Date_Arrete"), "yyyy:MM:dd"); }
		long debutPeriode = 0;
		long finPeriode = 0;
		
		DataEtatStock des = new DataEtatStock(s, valorisation, debutPeriode, finPeriode, famille1, famille2, famille3, marque, stockEntier, dateArrete);
		
		if (!fichierPdf.equals("")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
		
			PdfEtatStock pdfEtatStock = new PdfEtatStock(repTemp, des);			
			GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);	
			gd.addInternal(pdfEtatStock);	
			gd.close(GlobalDocument.ON_EXIT);
		} else if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvEtatStock(buffer, fichierCsv, des);
		}

		return true;

	} // fin service

} // fin GenEtatStock
