/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une fiche article
 */

package org.opensi.facturation.actions.editions;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;


public class FicheArticle extends Action {


private static final Font font9N = new Font(Font.HELVETICA, 9, Font.NORMAL);
private static final Font font10N = new Font(Font.HELVETICA, 10, Font.NORMAL);
private static final Font font9G = new Font(Font.HELVETICA, 9, Font.BOLD);
private static final Font font10G = new Font(Font.HELVETICA, 10, Font.BOLD);
private static final Font font16G = new Font(Font.HELVETICA, 14, Font.BOLD);

private DecimalFormat numFormat4 = new DecimalFormat("0.00##");
private DecimalFormat numFormat2 = new DecimalFormat("0.00");
private DecimalFormat numFormatQte = new DecimalFormat("0.##");
private SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");

private Connection con;
private String dossierId;
private String absdir;
private ResultSet art;
private boolean tarifQte;
private PreparedStatement psTarifsQte;


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		con = s.getConnection(null);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');

		numFormatQte.setDecimalFormatSymbols(dfs);
		numFormatQte.setNegativeSuffix("");
		numFormatQte.setNegativePrefix("-");
		numFormatQte.setPositiveSuffix(" ");
		numFormatQte.setGroupingUsed(true);
		numFormatQte.setGroupingSize(3);

		numFormat2.setDecimalFormatSymbols(dfs);
		numFormat2.setNegativeSuffix("");
		numFormat2.setNegativePrefix("-");
		numFormat2.setPositiveSuffix(" ");
		numFormat2.setGroupingUsed(true);
		numFormat2.setGroupingSize(3);

		numFormat4.setDecimalFormatSymbols(dfs);
		numFormat4.setNegativeSuffix("");
		numFormat4.setNegativePrefix("-");
		numFormat4.setPositiveSuffix(" ");
		numFormat4.setGroupingUsed(true);
		numFormat4.setGroupingSize(3);

		String base = s.getCookie().get("BaseDossier");

		dossierId = s.getCookie().get("Dossier_Id");
		absdir = s.getAppConfiguration().get("opensi.absdir");

		String refArticle = r.getParameter("Article_Id");

		Statement stt = con.createStatement();
		Statement stt2 = con.createStatement();

		String reqArticles = "select f.*, coalesce(ma.Libelle,'') as Marque, fa1.Libelle as Famille1, coalesce(fa2.Libelle,'') as Famille2, coalesce(fa3.Libelle,'') as Famille3,";
		reqArticles += " s.Stock_Init, s.Entrees, s.Sorties, s.Com_Clients, s.Com_Fournisseurs from "+ base +".FICHE_ARTICLE f join "+ base +".FAMILLE_ARTICLE fa1 on f.Famille_1=fa1.Famille_Id";
		reqArticles += " left join "+ base +".FAMILLE_ARTICLE fa2 on f.Famille_2=fa2.Famille_Id";
		reqArticles += " left join "+ base +".FAMILLE_ARTICLE fa3 on f.Famille_3=fa3.Famille_Id";
		reqArticles += " left join "+ base +".MARQUE_ARTICLE ma on f.Marque_Id=ma.Marque_Id,";
		reqArticles += base +".STOCKS_ARTICLE s where f.Supprime=0 and f.Article_Id=s.Article_Id";

		if (refArticle!=null) {
			reqArticles += " and f.Article_Id='"+ s.sqlEncode(refArticle) +"'";
		}
		else {
			
			int famille1 = Integer.parseInt(r.getParameter("Famille_1"));
			int famille2 = Integer.parseInt(r.getParameter("Famille_2"));
			int famille3 = Integer.parseInt(r.getParameter("Famille_3"));
			int marque = Integer.parseInt(r.getParameter("Marque"));

			if (famille1 != 0) {
				reqArticles += " and f.Famille_1="+ famille1;
				if (famille2 != 0) {
					reqArticles += " and f.Famille_2="+ famille2;
					if (famille3 != 0) {
						reqArticles += " and f.Famille_3="+ famille3;
					}
				}
			}


			if (marque != 0) {
				reqArticles += " and f.Marque_Id="+ marque;
			}

		}

		art = stt.executeQuery(reqArticles);


		ResultSet rsMT = stt2.executeQuery("select Mode_Tarif from "+ base +".PARAM_DOSSIER");

		rsMT.next();
		tarifQte = rsMT.getString("Mode_Tarif").equalsIgnoreCase("Q");
		rsMT.close();


		String reqNomenclature = "select f.Article_Id, f.Designation, n.Quantite from "+ base +".FICHE_ARTICLE f, "+ base +".COMPOSANT_ARTICLE n ";
						reqNomenclature += "where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";

		PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);

		PreparedStatement psTva = con.prepareStatement("select Taux_TVA from "+ base +".TAUX_TVA where Code_TVA=?");

		psTarifsQte = con.prepareStatement("select * from "+ base +".TARIF_QTE where Article_Id=? order by Quantite");


		Document document = new Document(PageSize.A4, 30, 20, 20, 20);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";
		String fichierPdf = chemin + r.getParameter("FichierPdf");

		PdfWriter.getInstance(document, new FileOutputStream(fichierPdf));


		document.open();

		while (art.next()) {

			psTva.setInt(1, art.getInt("Code_TVA"));
			ResultSet rsTva = psTva.executeQuery();
			rsTva.next();
			double tva = rsTva.getDouble("Taux_TVA");
			rsTva.close();

			document.add(cadreTitre());
			document.add(space(5));
			document.add(cadreDesignation());
			document.add(space(5));
			document.add(cadrePhotoDetails());
			document.add(space(5));
			document.add(cadreTarifs(tva));
			document.add(space(5));
			document.add(cadreDescription());
			document.add(space(5));

			if (art.getInt("Imp_Nom_Fiche")==1) {
				psNomenclature.setString(1, art.getString("Article_Id"));
				ResultSet rsNom = psNomenclature.executeQuery();

				if (rsNom.next()) {
					rsNom.beforeFirst();
					document.add(cadreNomenclature(rsNom));
				}
			}

			document.newPage();
		}

		document.close();


		s.closeConnection(con, null);


		try {
			File filePdf = new File(fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}

		return true;


	} // fin service



	private PdfPTable cadreTitre() {

		PdfPTable ppt = new PdfPTable(1);
		ppt.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPadding(8);

		cell.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
		cell.setPhrase(new Phrase("FICHE ARTICLE", font16G));
		ppt.addCell(cell);

		cell.setPaddingTop(0);
		cell.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		cell.setPhrase(new Phrase("\u00E9dition du "+ formatDate.format(new Date(System.currentTimeMillis())), font9N));
		ppt.addCell(cell);

		return ppt;
	}


	private PdfPTable cadreDesignation() throws SQLException, DocumentException {

		PdfPTable ppt = new PdfPTable(2);
		ppt.setWidthPercentage(100);
		int widths[] = {15, 85};
		ppt.setWidths(widths);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setBorder(PdfPCell.NO_BORDER);

		cell.setPhrase(new Phrase("R\u00E9f\u00E9rence :", font10G));
		ppt.addCell(cell);

		cell.setPhrase(new Phrase(art.getString("Article_Id"), font10G));
		ppt.addCell(cell);

		cell.setPhrase(new Phrase("Marque :", font10G));
		ppt.addCell(cell);

		cell.setPhrase(new Phrase(art.getString("Marque"), font10G));
		ppt.addCell(cell);

		cell.setPhrase(new Phrase("D\u00E9signation :", font10G));
		ppt.addCell(cell);

		cell.setPhrase(new Phrase(art.getString("Designation"), font10G));
		ppt.addCell(cell);

		cell = cellule(ppt);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setPadding(10);

		PdfPTable pptg = new PdfPTable(1);
		pptg.setWidthPercentage(100);
		pptg.addCell(cell);

		return pptg;
	}


	private PdfPTable cadrePhotoDetails() throws DocumentException, SQLException {

		PdfPTable ppt = new PdfPTable(3);
		ppt.setWidthPercentage(100);
		int widths[] = {30, 2, 68};
		ppt.setWidths(widths);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());

		try {
			Image photo = Image.getInstance(this.absdir +"/photos_articles/"+ dossierId +"/"+ art.getString("Article_Id") +"_big.jpg");
      if (photo.getDpiX()!=0 && photo.getDpiY()!=0)
				photo.scaleAbsolute(photo.getPlainWidth() * 72 / photo.getDpiX(), photo.getPlainHeight() * 72 / photo.getDpiY());

			cell = new PdfPCell(photo, true);
		}
		catch (IOException e) {
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase("Photo de l'article\n\nnon disponible", font10N));
		}

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setFixedHeight(150);
		ppt.addCell(cell);
		cell.setImage(null);

		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(""));
		ppt.addCell(cell);

		cell = new PdfPCell(cadreDetails());
		cell.setBorder(PdfPCell.NO_BORDER);

		ppt.addCell(cell);

		return ppt;
	}


	private PdfPTable cadreDetails() throws SQLException {

		PdfPTable ppt = new PdfPTable(1);
		ppt.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setBorder(PdfPCell.NO_BORDER);


		// cadre haut
		PdfPTable ppt1 = new PdfPTable(2);
		ppt1.setWidthPercentage(100);

		cell.setPhrase(new Phrase("Famille 1 : "+ art.getString("Famille1"), font10N));
		ppt1.addCell(cell);

		cell.setPhrase(new Phrase("Famille 2 : "+ art.getString("Famille2"), font10N));
		ppt1.addCell(cell);
		
		cell.setPhrase(new Phrase("Famille 3 : "+ art.getString("Famille3"), font10N));
		ppt1.addCell(cell);

		ppt1.addCell(cellSpace(2,8));

		cell.setPhrase(new Phrase("Nature : "+ (art.getInt("Nature")==0?"Mati\u00E8re premi\u00E8re":"Produit fini"), font10N));
		ppt1.addCell(cell);

		cell.setPhrase(new Phrase("Localisation : "+ art.getString("Localisation"), font10N));
		ppt1.addCell(cell);

		ppt1.addCell(cellSpace(2,8));

		cell.setColspan(2);
		cell.setPhrase(new Phrase("Conditionnement : "+ art.getString("Conditionnement"), font10N));
		ppt1.addCell(cell);

		ppt1.addCell(cellSpace(2,8));

		cell.setPhrase(new Phrase("Art. de substitution : "+ art.getString("Article_Substitution"), font10N));
		ppt1.addCell(cell);
		cell.setColspan(1);


		// cadre stocks
		PdfPTable ppt2 = new PdfPTable(3);
		ppt2.setWidthPercentage(100);

		double reel = art.getDouble("Stock_Init") + art.getDouble("Entrees") - art.getDouble("Sorties");

		cell.setPhrase(new Phrase("Stock r\u00E9el : "+ numFormatQte.format(reel), font10N));
		ppt2.addCell(cell);

		double dispo = reel - art.getDouble("Com_Clients");

		cell.setPhrase(new Phrase("Stock dispo : "+ numFormatQte.format(dispo), font10N));
		ppt2.addCell(cell);

		double virtuel = dispo + art.getDouble("Com_Fournisseurs");

		cell.setPhrase(new Phrase("Stock virtuel : "+ numFormatQte.format(virtuel), font10N));
		ppt2.addCell(cell);


		// cadre comptes
		PdfPTable ppt3 = new PdfPTable(2);
		ppt3.setWidthPercentage(100);

		cell.setPhrase(new Phrase("Compte de vente : ", font10N));
		ppt3.addCell(cell);

		cell.setPhrase(new Phrase("Compte d'achat : ", font10N));
		ppt3.addCell(cell);



		cell = cellule(ppt1);
		cell.setPadding(5);
		cell.setFixedHeight(90);
		ppt.addCell(cell);

		cell = cellule(space(5));
		cell.setBorder(PdfPCell.NO_BORDER);
		ppt.addCell(cell);

		cell = cellule(ppt2);
		cell.setPadding(5);
		cell.setFixedHeight(25);
		ppt.addCell(cell);

		cell = cellule(space(5));
		cell.setBorder(PdfPCell.NO_BORDER);
		ppt.addCell(cell);

		cell = cellule(ppt3);
		cell.setPadding(5);
		cell.setFixedHeight(25);
		ppt.addCell(cell);

		return ppt;
	}


	private PdfPTable cadreDescription() throws SQLException, DocumentException {

		PdfPTable ppt = new PdfPTable(3);
		ppt.setWidthPercentage(100);
		int widths[] = {49, 2, 49};
		ppt.setWidths(widths);


		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());

		cell.setPadding(8);
		cell.setMinimumHeight(100);

		if (art.getInt("Imp_Desc1_Fiche")==1) {
			Phrase desc1 = new Phrase();

			Chunk ch1 = new Chunk("Description 1 :\n\n", font10G);
			Chunk ch2 = new Chunk(art.getString("Descrip_1"), font10N);
			desc1.add(ch1);
			desc1.add(ch2);

			cell.setPhrase(desc1);
		}
		else {
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setPhrase(new Phrase(""));
		}
		
		ppt.addCell(cell);


		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase("", font10N));
		ppt.addCell(cell);

		if (art.getInt("Imp_Desc2_Fiche")==1) {
			Phrase desc2 = new Phrase();

			Chunk ch1 = new Chunk("Description 2 :\n\n", font10G);
			Chunk ch2 = new Chunk(art.getString("Descrip_2"), font10N);
			desc2.add(ch1);
			desc2.add(ch2);

			cell.setBorder(PdfPCell.BOX);
			cell.setPhrase(desc2);
		}
		else {
			cell.setBorder(PdfPCell.NO_BORDER);
			cell.setPhrase(new Phrase(""));
		}
	
		ppt.addCell(cell);

		return ppt;
	}


	private PdfPTable cadreNomenclature(ResultSet rset) throws SQLException, DocumentException {

		PdfPTable ppt = new PdfPTable(1);
		ppt.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());

		PdfPTable pptN = new PdfPTable(3);
		pptN.setWidthPercentage(100);
		int widths[] = {30, 15, 55};
		pptN.setWidths(widths);

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cell.setPhrase(new Phrase("R\u00E9f\u00E9rence", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("Quantit\u00E9", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("D\u00E9signation", font9G));
		pptN.addCell(cell);

		cell.setBackgroundColor(Color.WHITE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);

		while (rset.next()) {

			cell.setPhrase(new Phrase(rset.getString("Article_Id"), font9N));
			pptN.addCell(cell);

			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase(numFormatQte.format(rset.getDouble("Quantite")), font9N));
			pptN.addCell(cell);

			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase(rset.getString("Designation"), font9N));
			pptN.addCell(cell);

		}


		cell = new PdfPCell(ppt.getDefaultCell());
		cell.setPadding(8);
		cell.setPaddingBottom(0);
		cell.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
		cell.setPhrase(new Phrase("Nomenclature :\n\n", font10G));
		ppt.addCell(cell);

		cell = cellule(pptN);
		cell.setPadding(8);
		cell.setPaddingTop(0);
		cell.setBorder(PdfPCell.BOX - PdfPCell.TOP);
		ppt.addCell(cell);

		return ppt;
	}



	private PdfPTable cadreTarifs(double tva) throws SQLException, DocumentException {

		PdfPTable ppt = new PdfPTable(2);
		ppt.setWidthPercentage(100);
		int widthsG[] = {30, 70};
		ppt.setWidths(widthsG);

		PdfPCell cell = new PdfPCell(ppt.getDefaultCell());


		double pr = art.getDouble("Prix_Achat") + art.getDouble("Frais_Appro");


		PdfPTable pptN1 = new PdfPTable(2);
		pptN1.setWidthPercentage(100);
		//int widths[] = {10, 20, 25, 25, 20};
		//pptN.setWidths(widths);
		cell = new PdfPCell(ppt.getDefaultCell());
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		if (!tarifQte || art.getInt("Base_Calcul")==1) {

			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase("Prix d'achat", font9G));
			pptN1.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat2.format(art.getDouble("Prix_Achat")), font9N));
			pptN1.addCell(cell);

			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase("Frais d'appro.", font9G));
			pptN1.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat2.format(art.getDouble("Frais_Appro")), font9N));
			pptN1.addCell(cell);

			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			cell.setPhrase(new Phrase("Prix de revient", font9G));
			pptN1.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(numFormat2.format(pr), font9N));
			pptN1.addCell(cell);
		}

		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("Taux de TVA", font9G));
		pptN1.addCell(cell);

		cell.setBackgroundColor(Color.WHITE);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat2.format(tva) +" %", font9N));
		pptN1.addCell(cell);

		cell.setPhrase(new Phrase("", font9N));
		cell.setColspan(2);
		cell.setMinimumHeight(0);
		cell.setBorder(PdfPCell.NO_BORDER);
		pptN1.addCell(cell);


		PdfPTable pptN2;

		if (tarifQte) {
			pptN2 = tarifsQte(tva, pr);
		}
		else {
			pptN2 = tarifsClient(tva, pr);
		}


		cell = new PdfPCell(ppt.getDefaultCell());
		cell.setPadding(8);
		cell.setColspan(2);
		cell.setPaddingBottom(0);
		cell.setBorder(PdfPCell.BOX - PdfPCell.BOTTOM);
		cell.setPhrase(new Phrase("Tarifs :\n\n", font10G));
		ppt.addCell(cell);

		cell = cellule(pptN1);
		cell.setPadding(8);
		cell.setPaddingTop(0);
		cell.setBorder(PdfPCell.LEFT + PdfPCell.BOTTOM);
		ppt.addCell(cell);

		cell = cellule(pptN2);
		cell.setPadding(8);
		cell.setPaddingTop(0);
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.BOTTOM);
		ppt.addCell(cell);

		return ppt;
	}


	private PdfPTable tarifsClient(double tva, double pr) throws SQLException, DocumentException {

		PdfPTable pptN = new PdfPTable(5);
		pptN.setWidthPercentage(100);
		int widths[] = {15, 20, 25, 25, 15};
		pptN.setWidths(widths);

		PdfPCell cell = new PdfPCell(pptN.getDefaultCell());

		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

		cell.setPhrase(new Phrase("", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("Coefficient", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("Prix de vente HT", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("Prix de vente TTC", font9G));
		pptN.addCell(cell);

		cell.setPhrase(new Phrase("Marge %", font9G));
		pptN.addCell(cell);

		for (int i=1; i<=5; i++) {

			cell.setPaddingRight(4);
			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			cell.setPhrase(new Phrase("Tarif "+ i, font9G));
			pptN.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			cell.setPhrase(new Phrase(""+ art.getDouble("Coeff_"+ i), font9N));
			pptN.addCell(cell);

			double pv = art.getDouble("Tarif_"+ i);

			cell.setPhrase(new Phrase(numFormat4.format(pv), font9N));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase(numFormat2.format(pv * (1+ tva/100)), font9N));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase(numFormat2.format((pv - pr) / pv * 100), font9N));
			pptN.addCell(cell);
		}

		return pptN;
	}


	private PdfPTable tarifsQte(double tva, double pr) throws SQLException, DocumentException {


		boolean bc = art.getInt("Base_Calcul")==1;

		PdfPTable pptN;

		if (bc) {
			pptN = new PdfPTable(7);
			pptN.setWidthPercentage(100);
			int widths[] = {17, 17, 12, 12, 15, 15, 12};
			pptN.setWidths(widths);

			PdfPCell cell = new PdfPCell(pptN.getDefaultCell());

			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			cell.setPhrase(new Phrase("Lib.Interne", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Lib.Externe", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Qt\u00E9", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Coeff.", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Prix HT", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Prix TTC", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Marge %", font9G));
			pptN.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);


			psTarifsQte.setString(1, art.getString("Article_Id"));
			ResultSet rset = psTarifsQte.executeQuery();


			while (rset.next()) {

				cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cell.setPaddingRight(2);
				cell.setPhrase(new Phrase(tronque(rset.getString("Lib_Int"), 10), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(tronque(rset.getString("Lib_Ext"), 10), font9N));
				pptN.addCell(cell);

				cell.setPaddingRight(4);
				cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				cell.setPhrase(new Phrase(numFormatQte.format(rset.getDouble("Quantite")), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(""+ rset.getDouble("Coeff"), font9N));
				pptN.addCell(cell);

				double pv = rset.getDouble("Prix");

				cell.setPhrase(new Phrase(numFormat4.format(pv), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(numFormat2.format(pv * (1+ tva/100)), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(numFormat2.format((pv - pr) / pv * 100), font9N));
				pptN.addCell(cell);
			}

			cell.setPhrase(new Phrase("", font9N));
			cell.setColspan(7);
			cell.setMinimumHeight(0);
			cell.setBorder(PdfPCell.NO_BORDER);
			pptN.addCell(cell);
		}
		else {

			pptN = new PdfPTable(5);
			pptN.setWidthPercentage(100);
			int widths[] = {20, 20, 20, 20, 20};
			pptN.setWidths(widths);

			PdfPCell cell = new PdfPCell(pptN.getDefaultCell());

			cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
			cell.setBackgroundColor(Color.LIGHT_GRAY);
			cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);

			cell.setPhrase(new Phrase("Lib.Interne", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Lib.Externe", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Quantit\u00E9", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Prix HT", font9G));
			pptN.addCell(cell);

			cell.setPhrase(new Phrase("Prix TTC", font9G));
			pptN.addCell(cell);

			cell.setBackgroundColor(Color.WHITE);

			psTarifsQte.setString(1, art.getString("Article_Id"));
			ResultSet rset = psTarifsQte.executeQuery();


			while (rset.next()) {

				cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cell.setPaddingRight(2);
				cell.setPhrase(new Phrase(tronque(rset.getString("Lib_Int"), 12), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(tronque(rset.getString("Lib_Ext"), 12), font9N));
				pptN.addCell(cell);

				cell.setPaddingRight(4);
				cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				cell.setPhrase(new Phrase(numFormatQte.format(rset.getDouble("Quantite")), font9N));
				pptN.addCell(cell);

				double pv = rset.getDouble("Prix");

				cell.setPhrase(new Phrase(numFormat4.format(pv), font9N));
				pptN.addCell(cell);

				cell.setPhrase(new Phrase(numFormat2.format(pv * (1+ tva/100)), font9N));
				pptN.addCell(cell);
			}

			cell.setPhrase(new Phrase("", font9N));
			cell.setColspan(5);
			cell.setMinimumHeight(0);
			cell.setBorder(PdfPCell.NO_BORDER);
			pptN.addCell(cell);
		}

		return pptN;
	}



	private PdfPTable space(int space) {

		PdfPTable sectionSpace = new PdfPTable(1);
		sectionSpace.setWidthPercentage(100);

		PdfPCell cell = new PdfPCell(sectionSpace.getDefaultCell());

		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(space);
		cell.setBorder(PdfPCell.NO_BORDER);
		sectionSpace.addCell(cell);

		return sectionSpace;
	}


	private PdfPCell cellule(PdfPTable ppt) {

		return new PdfPCell(ppt);
	}

	private PdfPCell cellSpace(int colspan, int space) {

		PdfPTable sectionSpace = new PdfPTable(1);

		PdfPCell cell = new PdfPCell(sectionSpace.getDefaultCell());

		cell.setPhrase(new Phrase(""));
		cell.setFixedHeight(space);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setColspan(colspan);

		return cell;
	}


	private String tronque(String str, int nb) {

		return ( str.length() <= nb ) ? str : str.substring(0,nb) + "...";
	}


} // fin FicheArticle
