/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration des tiquettes de colisage
 */

package org.opensi.facturation.actions.editions;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.facturation.actions.editions.etiquettes.CoordExp;
import org.opensi.facturation.actions.editions.etiquettes.Etiquette;
import org.opensi.facturation.actions.editions.etiquettes.InfosEtiquette;
import org.opensi.facturation.actions.editions.etiquettes.ModeleStd120X80;
import org.opensi.facturation.actions.editions.etiquettes.ModeleStd225X80;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;



public class Etiquettes extends Action {



  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {


		Connection con = s.getConnection(null);


		String base = s.getCookie().get("BaseDossier");
		String dossierId = s.getCookie().get("Dossier_Id");

		String bonId = r.getParameter("Bon_Id");
		
		int nbColis = (r.getParameter("Nb_Colis")==null?0:Integer.parseInt(r.getParameter("Nb_Colis")));

		boolean sansColisage = (nbColis>0);

		Statement sttCol = con.createStatement();
		Statement sttExp = con.createStatement();
		Statement sttLiv = con.createStatement();
		
		if (nbColis==0) {
			String reqNbCol = "select count(*) from "+ base +".COLIS where Bon_Id="+ bonId;

			ResultSet rsNb = sttCol.executeQuery(reqNbCol);
			rsNb.next();
			nbColis = rsNb.getInt(1);
			rsNb.close();
		}
		

		String reqModele = "select Modele_Etiquette from "+ base +".PARAM_DOSSIER";
		
		String reqExp = "select Denomination, Adresse_1, Adresse_2, Code_Postal, Ville, Telephone, Fax from "+ base +".SOCIETE";
		
		String reqLiv = "select b.Denomination_Liv, b.Adresse_1_Liv, b.Adresse_2_Liv, b.Code_Postal_Liv, b.Ville_Liv, a.Denomination as Client, a.Client_Id, a.Num_Entier as Num_Affaire, b.Num_Entier as Num_BL, c.Ref_Commande, c.Numero as Num_Commande"
									+ " from "+ base +".BON_LIVRAISON b,"+ base +".AFFAIRE a,"+ base +".COMMANDE_CLIENT c"
									+ " where c.Commande_Id=b.Commande_Id and c.Affaire_Id=a.Affaire_Id and b.Bon_Id="+ bonId;



		ResultSet rsMod = sttCol.executeQuery(reqModele);
		rsMod.next();
		String modele = rsMod.getString("Modele_Etiquette");
		rsMod.close();

		
		ResultSet rsExp = sttExp.executeQuery(reqExp);
		ResultSet rsLiv = sttLiv.executeQuery(reqLiv);

		rsExp.next();
		rsLiv.next();


		CoordExp exp = new CoordExp(rsExp.getString("Denomination"),rsExp.getString("Adresse_1"),rsExp.getString("Adresse_2"),
																		rsExp.getString("Code_Postal"),rsExp.getString("Ville"),rsExp.getString("Telephone"),rsExp.getString("Fax"));
		CoordExp dest = new CoordExp(rsLiv.getString("Denomination_Liv"),rsLiv.getString("Adresse_1_Liv"),rsLiv.getString("Adresse_2_Liv"),
																		rsLiv.getString("Code_Postal_Liv"),rsLiv.getString("Ville_Liv"));


		InfosEtiquette ie = new InfosEtiquette(nbColis, rsLiv.getString("Num_Affaire"),rsLiv.getString("Num_BL"),
																		rsLiv.getString("Ref_Commande"), rsLiv.getString("Num_Commande"),rsLiv.getString("Client_Id"), rsLiv.getString("Client"), dest, exp);


		String absdir = s.getAppConfiguration().get("opensi.absdir");

		Etiquette etiquette;

		if (modele.equals("STD01")) {
			etiquette = new ModeleStd120X80();
		}
		else if (modele.equals("STD02")) {
			etiquette = new ModeleStd225X80();
		}
		else {

			Statement stt = con.createStatement();
			ResultSet rsClass = stt.executeQuery("select Class from "+ base +".MODELE_ETIQUETTE where Modele_Id='"+ modele +"'");
			rsClass.next();
			Class<?> cl = Class.forName(rsClass.getString("Class"));
			etiquette = (Etiquette)cl.newInstance();
			rsClass.close();
			stt.close();
		}


		Document document = new Document(new Rectangle(toPoints(etiquette.getDimX()), toPoints(etiquette.getDimY())), 10, 10, 10, 10);

		String chemin = s.getAppConfiguration().get("opensi.absdir") +"/pdf/";
		String fichierPdf = chemin + r.getParameter("FichierPdf");

		PdfWriter.getInstance(document, new FileOutputStream(fichierPdf));


		document.open();
		
		int numColis = 1;		
		
		if (sansColisage) {
			
			while (numColis<=nbColis) {

				ie.setNumColis(numColis);
				document.add(etiquette.makeEtiquette(absdir, ie));
				numColis++;

				document.newPage();
			}
		}
		else {
		
			String reqCol = "select * from "+ base +".COLIS where Bon_Id="+ bonId;
						
			ResultSet rsCol = sttCol.executeQuery(reqCol);		
		
			while (rsCol.next()) {

				ie.setNumColis(numColis);
				document.add(etiquette.makeEtiquette(absdir, ie));
				numColis++;

				document.newPage();
			}
		}

		document.close();


		s.closeConnection(con, null);


		try {
			File filePdf = new File(fichierPdf);
			filePdf.deleteOnExit();
		}
		catch(SecurityException se) {
			s.trace("Impossible d'enregistrer le fichier  supprimer");
			se.printStackTrace();
		}

		return true;


	} // fin service



	public float toPoints(double dim) {

		return (float) ((dim/10) / 2.54 * 72);
	}


} // fin Etiquettes
