/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un tableau des ventes par articles
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataVentesArticles {

	// les lignes de la liste des statistiques
	protected ArrayList<LigneVentesArticles> lignes = new ArrayList<LigneVentesArticles>(10);
	protected String finPeriodeStr;
	protected String debutPeriodeStr;	
	
	public DataVentesArticles(Session s, long debutPeriode, long finPeriode) {
		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			
			String reqFactures = "select Facture_Id, Date_Facture, Num_Entier, Denomination,";
			reqFactures += " Total_HT, Total_TTC, Total_TVA, Remise from " + base + ".FACTURE where Date_Facture>="+ debutPeriode +" and Date_Facture<="+ finPeriode;
			ResultSet rset = stt.executeQuery(reqFactures);
			
			String reqArticles = "select Reference, Designation, Quantite, Prix from "+ base +".LIGNE_FACTURE";
			reqArticles += " where Facture_Id=?";
			PreparedStatement psArticles = con.prepareStatement(reqArticles);

			String reqModeReg = "select Libelle from "+ base +".ECHEANCE_FACTURE_CLIENT efc join "+ base +".MODE_REGLEMENT mr on efc.Mode_Reg_Id=mr.Mode_Reg_Id";
			reqModeReg += " where Facture_Id=?";
			PreparedStatement psModeReg = con.prepareStatement(reqModeReg);

			while (rset.next()) {			
				psArticles.setInt(1, rset.getInt("Facture_Id"));
				ResultSet rset2 = psArticles.executeQuery();
				while (rset2.next()) {
					LigneVentesArticles lva = new LigneVentesArticles();
					lva.setDateFacture(rset.getLong("Date_Facture"));
					lva.setNumFacture(rset.getString("Num_Entier"));
					lva.setRaisonSociale(rset.getString("Denomination"));
					psModeReg.setInt(1, rset.getInt("Facture_Id"));
					ResultSet rset3 = psModeReg.executeQuery();
					if (rset3.next()) {
						lva.setModeReglement(rset3.getString("Libelle"));
					}
					else {
						lva.setModeReglement("");
					}
					lva.setTotalHT(rset.getDouble("Total_HT"));
					lva.setMontantTVA(rset.getDouble("Total_TVA"));
					lva.setMontantTTC(rset.getDouble("Total_TTC"));
					lva.setRemise(rset.getDouble("Remise"));
					lva.setReference(rset2.getString("Reference"));
					lva.setDesignation(rset2.getString("Designation"));
					lva.setQuantite(rset2.getDouble("Quantite"));
					lva.setPrixUnitaire(rset2.getDouble("Prix"));
					lignes.add(lva);
				}
				rset2.close();
			}
			psArticles.close();
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataVentesArticles
