/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes d'une ligne d'avoir standard
 */

package org.opensi.facturation.actions.documents.modeles;

import org.opensi.util.tools.StringUtils;


public class LigneAvoirFournisseur {	

	protected double price;
	protected String reference;
	protected String ref_fournisseur;
	protected String designation;
	protected double qte;
	protected String typeLigne;
	protected double ristourne;
	protected double tauxTva;
	protected double montant;
	protected String commentaire;
	protected String detail_1;
	protected String detail_2;
	protected String refBL;
	protected String couleur = "";
	protected String taille = "";
	protected String commentaireAvant;
	protected double sousTotal = 0;
	protected String unite = "";
	protected String num_lot = "";
	protected int nb_pieces = 0;
	protected long date_peremption = 0;
	protected char type;

	public void setPrice(double price) {	this.price = price;	}
	public void setReference(String reference) {	this.reference = reference;	}
	public void setRef_Fournisseur(String ref_fournisseur) {	this.ref_fournisseur = ref_fournisseur;	}
	public void setDesignation(String designation) {	this.designation = StringUtils.removeHtmlTags(designation);	}
	public void setQte(double qte) {	this.qte = qte;	}
	public void setRistourne(double ristourne) { this.ristourne = ristourne; }
	public void setTypeLigne(String typeLigne) { this.typeLigne = typeLigne; }
	public void setTva(double tauxTva) { this.tauxTva = tauxTva; }
	public void setMontant(double montant) { this.montant = montant; }
	public void setCommentaire(String commentaire) { this.commentaire = StringUtils.removeHtmlTags(commentaire); }
	public void setCommentaireAvant(String commentaireAvant) { this.commentaireAvant = StringUtils.removeHtmlTags(commentaireAvant); }
	public void setDetail_1(String detail_1) { this.detail_1 = detail_1; }
	public void setDetail_2(String detail_2) { this.detail_2 = detail_2; }
	public void setRefBL(String refBL) { this.refBL = refBL; }
	public void setCouleur(String couleur) { this.couleur = couleur; }
	public void setTaille(String taille) { this.taille = taille; }
	public void setUnite(String unite) { this.unite = unite; }
	public void setNumLot(String num_lot) { this.num_lot = num_lot; }
	public void setNbPieces(int nb_pieces) { this.nb_pieces = nb_pieces; }
	public void setDatePeremption(long date_peremption) { this.date_peremption = date_peremption; }
	public void setType(char type) { this.type = type; }
	public void setSousTotal(double sousTotal) { this.sousTotal = sousTotal; }
}
