/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'une liste des affaires
 */

package org.opensi.facturation.actions.affaires;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;
import org.opensi.util.tools.DateTime;


public class CsvListeAffaires {

	public CsvListeAffaires(String buffer, String fichier, DataListeAffaires dla) throws Exception {
		
		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("Date");
		lf.addToLine("N\u00B0 Affaire");
		lf.addToLine("Intitul\u00E9");
		lf.addToLine("Etat");
		lf.addToLine("N\u00B0 Client");
		lf.addToLine("Client");
		lf.addToLine("Dernier BL");
		lf.addToLine("Total HT");
		lf.addToLine("CA Livr\u00E9");
		lf.addToLine("CA Restant");

		int nbLignes = dla.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LigneListeAffaires lla = dla.lignes.get(i);

			lf.newLine();
			lf.addToLine(DateTime.formatTime(lla.dateAffaire, "dd/MM/yyyy"));
			lf.addToLine("\"" + lla.numAffaire + "\"");
			lf.addToLine("\"" + lla.intituleAffaire + "\"");
			lf.addToLine("\"" + lla.etatAffaire + "\"");
			lf.addToLine("\"" + lla.numClient + "\"");
			lf.addToLine("\"" + lla.nomClient + "\"");
			lf.addToLine(lla.dateDernierBL!=0?DateTime.formatTime(lla.dateDernierBL, "dd/MM/yyyy"):"");
			lf.addToLine(("" + lla.montantHT).replaceAll("\\.", ","));
			lf.addToLine(("" + lla.caLivre).replaceAll("\\.", ","));
			lf.addToLine(("" + lla.caRestant).replaceAll("\\.", ","));
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvListeAffaires
