/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

import org.experlog.openeas.api.Session;


public class CalculStock {

	private Connection con;
	private String base;
	private Session s;	
	private PreparedStatement psListeArt;
	private PreparedStatement psListeCom;
	private PreparedStatement psListeArtCom;
	private PreparedStatement psListeArtComHorsStock;
	private Double valeur [];
	private double stock;
	private double total;
	private double horsStock;
	private int comId;
	               
	private String reqListeArt;
	private String reqListeCom;
	private String reqListeArtCom;
	private String reqListeArtComHorsStock;

	private boolean calculStockReserve;

	private HashMap <String, Double> listeArt  = new HashMap<String, Double>(1000);
	private HashMap <Integer, Double[]> listeCom  = new HashMap<Integer, Double[]>(500);
	
	private HashMap <Integer, HashMap <Integer, Double[]>> listeArtCom  = new HashMap < Integer, HashMap <Integer, Double[]>>(500);
	private String reqComposants;
	private PreparedStatement psCompStock;
	ResultSet rset;
	private int ligneId;
	private Double[] valeurArt;

	public CalculStock(String s_, int dispo) {
		try {

			s = Session.findClient(s_);
			con = s.getConnection(null);
			base = s.getCookie().get("BaseDossier");
			this.calculStockReserve=(dispo==1);
			init();

		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public CalculStock(Session s, int dispo) {
		try {

			con = s.getConnection(null);
			base = s.getCookie().get("BaseDossier");
			this.calculStockReserve=(dispo==1);
			init();

		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	private void init() {
		try {
			reqComposants = "select ArticleComp_Id, Quantite, coalesce(Stock_Init+Entrees-Sorties,0) as reel from "+ base +".FICHE_ARTICLE a, "+ base +".COMPOSANT_ARTICLE c left join "+ base +".STOCKS_ARTICLE sa on sa.Article_Id=c.ArticleComp_Id where a.Article_Id=c.Article_Id and a.Composition='F' and a.Article_Id=?";   
			psCompStock = con.prepareStatement(reqComposants);

			
			reqListeArt = "select distinct sa.Article_Id,coalesce(Stock_Init+Entrees-Sorties,0) as reel from "+ base +".COMMANDE_CLIENT cw join "+ base +".LIGNE_COMMANDE_CLIENT lcc on cw.Commande_Id=lcc.Commande_Id";
			reqListeArt += " left join "+base +".STOCKS_ARTICLE sa on sa.Article_Id=lcc.Reference where lcc.Type_Ligne='S' and Etat='T' and lcc.Statut='V'";   

			psListeArt = con.prepareStatement(reqListeArt);

			ResultSet rsetli = psListeArt.executeQuery();
			while (rsetli.next()) {
				ajoutliste(rsetli.getString("Article_Id"), rsetli.getDouble("reel"));
			}

			reqListeArtCom = "select lcc.Ligne_Id, sa.Article_Id,if((coalesce(sum(lcc.Quantite),0)- qr.BL)>0,(coalesce(sum(lcc.Quantite),0)- qr.BL),0) as Quantite" +
			" from "+base +".STOCKS_ARTICLE sa join "+base +".LIGNE_COMMANDE_CLIENT lcc on sa.Article_Id=lcc.Reference" +
			" join (select lcc2.Reference, coalesce(sum(if(bl2.Etat='V', abl2.Quantite - coalesce(t.Quantite,0),0)),0) as BL from "+base +".LIGNE_COMMANDE_CLIENT lcc2" +
			" left join "+base +".LIGNE_BON_LIVRAISON abl2 on lcc2.Ligne_Id=abl2.Ref_Ligne and abl2.Statut='V' left join "+base +".BON_LIVRAISON bl2 on abl2.Bon_Id=bl2.Bon_Id" +
			" left join (select lbl.Ligne_Id, coalesce(sum(lbrc.Quantite),0) as Quantite from "+ base +".LIGNE_BON_LIVRAISON lbl join "+ base +".BON_LIVRAISON bl on lbl.Bon_Id=bl.Bon_Id and bl.Etat='V'"+
			" join "+ base +".LIGNE_BON_RETOUR_CLIENT lbrc on lbrc.Ligne_BL=lbl.Ligne_Id join "+ base +".BON_RETOUR_CLIENT brc on lbrc.Bon_Id=brc.Bon_Id and brc.Etat='V'"+
			" where lbl.Statut='V' and bl.Commande_Id=? group by lbl.Ligne_Id) as t on abl2.Ligne_Id=t.Ligne_Id"+
			" where lcc2.Commande_Id=? and lcc2.Statut='V' and Type_Ligne='S' group by lcc2.Reference) as qr on qr.Reference=lcc.Reference" +
			" where lcc.Commande_Id=? and lcc.Statut='V' and Type_Ligne='S' group by lcc.Ligne_Id";

			psListeArtCom = con.prepareStatement(reqListeArtCom);
			
			reqListeArtComHorsStock = "select Commande_Id,coalesce(sum(lcc.Quantite-qr.BL),0) as Quantite" +
			" from "+base +".LIGNE_COMMANDE_CLIENT lcc" +
			" join (select lcc2.Ligne_Id,coalesce(sum(if(bl2.Etat='V', abl2.Quantite, 0)),0) as BL from  "+base +".LIGNE_COMMANDE_CLIENT lcc2" +
			" left join "+base +".LIGNE_BON_LIVRAISON abl2 on lcc2.Ligne_Id=abl2.Ref_Ligne and abl2.Statut='V' left join "+base +".BON_LIVRAISON bl2 on abl2.Bon_Id=bl2.Bon_Id" +
			" where lcc2.Commande_Id=? and lcc2.Statut='V' and Type_Ligne='I' group by lcc2.Ligne_Id) as qr on qr.Ligne_Id=lcc.Ligne_Id" +
			" where lcc.Commande_Id=? and lcc.Statut='V' and Type_Ligne='I' group by Commande_Id";

			psListeArtComHorsStock = con.prepareStatement(reqListeArtComHorsStock);
			
			reqListeCom = "select Commande_Id from "+base +".COMMANDE_CLIENT where Etat='T' and Statut_Logistique='T' order by Date_Validation";
			psListeCom = con.prepareStatement(reqListeCom);
			ResultSet rsetcom = psListeCom.executeQuery();
			while (rsetcom.next()) {
				comId = rsetcom.getInt("Commande_Id");
				valeur=new Double[3];
				stock=0;
				total=0;
				horsStock=0;
				psListeArtCom.setInt(1, comId);
				psListeArtCom.setInt(2, comId);
				psListeArtCom.setInt(3, comId);
				ResultSet rsetArtcom = psListeArtCom.executeQuery();
				while (rsetArtcom.next()) {
					ligneId = rsetArtcom.getInt("Ligne_Id");
					String article_id = rsetArtcom.getString("Article_Id");
					calcul(comId, ligneId, rsetArtcom.getDouble("Quantite"),article_id,1);
				}
				valeur[0]= stock;
				valeur[1]= total;
				
				psListeArtComHorsStock.setInt(1, comId);
				psListeArtComHorsStock.setInt(2, comId);
				ResultSet rsetArtcomHorsStock = psListeArtComHorsStock.executeQuery();
				while (rsetArtcomHorsStock.next()) {
					horsStock = rsetArtcomHorsStock.getDouble("Quantite");
				}

				valeur[2]= horsStock;
				listeCom.put(comId, valeur);
				
			}

		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public void ajoutliste(String article_id, double reel) {
		try {
			psCompStock.setString(1, article_id);
			rset = psCompStock.executeQuery();
			if (rset.next()) {
				do {			
					ajoutliste(rset.getString("ArticleComp_Id"),rset.getDouble("reel"));
				}	
				while (rset.next());
			}
			else {
				listeArt.put(article_id,reel);
			}
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	
	public void calcul(int commandeId, int ligneId, double quantite, String article_id, double multiple) {
		try {

				double reel = listeArt.get(article_id);
				double alivrer = quantite*multiple;
				total+=alivrer;
				double ajout=(reel>0)?((reel<=alivrer && reel>0)?reel:alivrer):0;
				stock+=ajout;
				valeurArt=new Double[2];
				valeurArt[0]= ajout;
				valeurArt[1]= alivrer;

				if (listeArtCom.containsKey(commandeId)) {
					HashMap <Integer, Double[]> hashMapArticle = listeArtCom.get(commandeId);
					hashMapArticle.put(ligneId, valeurArt);
					listeArtCom.put(commandeId,hashMapArticle);
				}
				else {
					HashMap <Integer, Double[]> hashMapArticle  = new HashMap<Integer, Double[]>(1);
					hashMapArticle.put(ligneId, valeurArt);
					listeArtCom.put(commandeId,hashMapArticle);
				}
				
				if (calculStockReserve) {
					listeArt.put(article_id,reel-ajout);
				}	
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
		
	public double stock(int Commande_Id) {
		try {
			return listeCom.containsKey(Commande_Id)?listeCom.get(Commande_Id)[0]:0;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}

	public double total(int Commande_Id) {
		try {
			return listeCom.containsKey(Commande_Id)?listeCom.get(Commande_Id)[1]:0;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}
	
	public double horsstock(int Commande_Id) {
		try {
			return listeCom.containsKey(Commande_Id)?listeCom.get(Commande_Id)[2]:0;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}
	
	public double stockLigne(int Commande_Id, int ligneId) {
		try {
			return listeArtCom.containsKey(Commande_Id)?listeArtCom.get(Commande_Id).containsKey(ligneId)?listeArtCom.get(Commande_Id).get(ligneId)[0]:0:0;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}

	public double totalLigne(int Commande_Id, int ligneId) {
		try {
			return listeArtCom.containsKey(Commande_Id)?listeArtCom.get(Commande_Id).containsKey(ligneId)?listeArtCom.get(Commande_Id).get(ligneId)[1]:0:0;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}
	public double horsstockLigne(int Commande_Id, int ligneId) {
		try {
			return listeArtCom.containsKey(Commande_Id)?listeArtCom.get(Commande_Id).containsKey(ligneId)?0:1:1;
		} catch(Exception e) {
			e.printStackTrace();
			return 0.0;
		}
	}

	
	protected void finalize() {
		try {
			if (s!=null) {
				s.closeConnection(con, null);
			}
		}
		catch(SQLException e) {
			e.printStackTrace();
		}
	}	


} // fin StockManager


