/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.dossier.TrancheCollectif;


public class DBM_TrancheCollectif implements DBM_Object {

	private Connection con;
	private String baseDossier;

	
	public DBM_TrancheCollectif(Connection con, String baseDossier) {
		
		this.baseDossier = baseDossier;
		this.con = con;
	}
	
	
	public boolean exist(int trancheId) throws SQLException {
		
		PreparedStatement psExiste = con.prepareStatement("select 1 from "+ baseDossier +".TRANCHE_COLLECTIF where Tranche_Id=?");
			
		psExiste.setInt(1, trancheId);
		ResultSet rset = psExiste.executeQuery();
		
		boolean existe = rset.next();
		
		rset.close();
		psExiste.close();
		
		return existe;
	}
	
	
	public TrancheCollectif load(int trancheId) throws SQLException {
	
		TrancheCollectif trancheCollectif = null;
	
		PreparedStatement psLoad = con.prepareStatement("select * from "+ baseDossier +".TRANCHE_COLLECTIF where Tranche_Id=?");
		
		psLoad.setInt(1, trancheId);
		ResultSet rset = psLoad.executeQuery();
		
		if (rset.next()) {			
			trancheCollectif = new TrancheCollectif();
			
			trancheCollectif.setTrancheId(trancheId);
			trancheCollectif.setMinCompte(rset.getString("Min_Compte"));
			trancheCollectif.setMaxCompte(rset.getString("Max_Compte"));             
		}
		rset.close();
		psLoad.close();
		
		return trancheCollectif;
	}


	public int insert(TrancheCollectif trancheCollectif) throws SQLException {
		
		PreparedStatement psNewTrancheCollectif = con.prepareStatement("insert into "+ baseDossier +".TRANCHE_COLLECTIF (Min_Compte, Max_Compte) values (?,?)");

		psNewTrancheCollectif.setString(1, trancheCollectif.getMinCompte());
		psNewTrancheCollectif.setString(2, trancheCollectif.getMaxCompte());
		psNewTrancheCollectif.executeUpdate();
		
		ResultSet rsID = psNewTrancheCollectif.getGeneratedKeys();
		rsID.next();
		int trancheId = rsID.getInt(1);
		rsID.close();
		
		return trancheId;
	} 


	public void update(TrancheCollectif trancheCollectif) throws SQLException {
	
		PreparedStatement psUpTrancheCollectif = con.prepareStatement("update "+ baseDossier +".TRANCHE_COLLECTIF set Min_Compte=?, Max_Compte=? where Tranche_Id=?");
				
		psUpTrancheCollectif.setString(1, trancheCollectif.getMinCompte());
		psUpTrancheCollectif.setString(2, trancheCollectif.getMaxCompte());
		psUpTrancheCollectif.setInt(3, trancheCollectif.getTrancheId());
		psUpTrancheCollectif.executeUpdate();
		psUpTrancheCollectif.close();
	}
	
	
	public void delete(int trancheId) throws SQLException {
	
		PreparedStatement psSupTrancheCollectif = con.prepareStatement("delete from "+ baseDossier +".TRANCHE_COLLECTIF where Tranche_Id=?");

		psSupTrancheCollectif.setInt(1, trancheId);		
		psSupTrancheCollectif.executeUpdate();
		psSupTrancheCollectif.close();
	}
		

} // fin DBM_TrancheCollectif
