/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class Facture implements org.opensi.api.DataOSI {
	
	
	private int factureId;
	private int numUnique;
	private long dateC;
	private long dateM;
	private int utilC;
	private int utilM;
	private int utilR;
	private String nomResp;
	private String prenomResp;
	private long dateFacture;
	private long dateEcheance;
	private String modeReg;
	private int numero;
	private String numEntier;
	private String commentairesFin;
	private String commentairesInt;
	private String commentairesHid;
	private String clientId;
	private Adresse adresseFact;
	private Contact contactFact;
	private Adresse adresseLiv;
	private Contact contactLiv;
	private Adresse adresseEnvoi;
	private Contact contactEnvoi;
	private double acompte;
	private double remise;
	private double montantRemise;
	private double pRemiseFP;
	private double mRemiseFP;
	private double escompte;
	private double fraisPort;
	private double totalHT;
	private double totalTVA;
	private double totalTTC;
	private boolean directe;
	private int codeTarif;
	private boolean transferee;
	private double tauxTVAPort;
	private int codeTVAPort;
	private boolean editionTTC;
	private double ecoTaxe;
	private double tauxIndicatif;
	private boolean assujettiTVA;
	private boolean tvaLiv;
	private String numTVAIntra;
	private String regimeTVA;
	private String mentions;
	private long dateDEB;
	private long dateEditionLot;
	private long dateEditionAuto;
	private String modeEnvoiFacture;
	private long dateEnvoi;
	private int versCalc;
	private HashMap<Integer, LigneFacture> lignesFacture;

	
	public Facture(int factureId,
					int numUnique,
					long dateC,
					long dateM,
					int utilC,
					int utilM,
					int utilR,
					String nomResp,
					String prenomResp,
					long dateFacture,
					long dateEcheance,
					String modeReg,
					int numero,
					String numEntier,
					String commentairesFin,
					String commentairesInt,
					String commentairesHid,
					String clientId,
					Adresse adresseFact,
					Contact contactFact,
					Adresse adresseLiv,
					Contact contactLiv,
					Adresse adresseEnvoi,
					Contact contactEnvoi,
					double acompte,
					double remise,
					double montantRemise,
					double pRemiseFP,
					double mRemiseFP,
					double escompte,
					double fraisPort,
					double totalHT,
					double totalTVA,
					double totalTTC,
					boolean directe,
					int codeTarif,
					boolean transferee,
					double tauxTVAPort,
					int codeTVAPort,
					boolean editionTTC,
					double ecoTaxe,
					double tauxIndicatif,
					boolean assujettiTVA,
					boolean tvaLiv,
					String numTVAIntra,
					String regimeTVA,
					String mentions,
					long dateDEB,
					long dateEditionLot,
					long dateEditionAuto,
					String modeEnvoiFacture,
					long dateEnvoi,
					int versCalc) {
		
		this.factureId = factureId;
		this.numUnique = numUnique;
		this.dateC = dateC;
		this.dateM = dateM;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.nomResp = nomResp;
		this.prenomResp = prenomResp;
		this.dateFacture = dateFacture;
		this.dateEcheance = dateEcheance;
		this.modeReg = modeReg;
		this.numero = numero;
		this.numEntier = numEntier;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.commentairesHid = commentairesHid;
		this.clientId = clientId;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.adresseLiv = adresseLiv;
		this.contactLiv = contactLiv;
		this.adresseEnvoi = adresseEnvoi;
		this.contactEnvoi = contactEnvoi;
		this.acompte = acompte;
		this.remise = remise;
		this.montantRemise = montantRemise;
		this.pRemiseFP = pRemiseFP;
		this.mRemiseFP = mRemiseFP;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.totalHT = totalHT;
		this.totalTVA = totalTVA;
		this.totalTTC = totalTTC;
		this.directe = directe;
		this.codeTarif = codeTarif;
		this.transferee = transferee;
		this.tauxTVAPort = tauxTVAPort;
		this.codeTVAPort = codeTVAPort;
		this.editionTTC = editionTTC;
		this.ecoTaxe = ecoTaxe;
		this.tauxIndicatif = tauxIndicatif;
		this.assujettiTVA = assujettiTVA;
		this.tvaLiv = tvaLiv;
		this.numTVAIntra = numTVAIntra;
		this.regimeTVA = regimeTVA;
		this.mentions = mentions;
		this.dateDEB = dateDEB;
		this.dateEditionLot = dateEditionLot;
		this.dateEditionAuto = dateEditionAuto;
		this.modeEnvoiFacture = modeEnvoiFacture;
		this.dateEnvoi = dateEnvoi;
		this.versCalc = versCalc;
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneFacture ligneFacture) { this.lignesFacture.put(ligneId, ligneFacture); }
	
	public int getFactureId() { return factureId; }
	public int getNumUnique() { return numUnique; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public String getNomResp() { return nomResp; }
	public String getPrenomResp() { return prenomResp; }
	public long getDateFacture() { return dateFacture; }
	public long getDateEcheance() { return dateEcheance; }
	public String getModeReg() { return modeReg; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getCommentairesHid() { return commentairesHid; }
	public String getClientId() { return clientId; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public Contact getContactLiv() { return contactLiv; }
	public Adresse getAdresseEnvoi() { return adresseEnvoi; }
	public Contact getContactEnvoi() { return contactEnvoi; }
	public double getAcompte() { return acompte; }
	public double getRemise() { return remise; }
	public double getMontantRemise() { return montantRemise; }
	public double getPRemiseFP() { return pRemiseFP; }
	public double getMRemiseFP() { return mRemiseFP; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTVA() { return totalTVA; }
	public double getTotalTTC() { return totalTTC; }
	public boolean getDirecte() { return directe; }
	public int getCodeTarif() { return codeTarif; }
	public boolean getTransferee() { return transferee; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public boolean getEditionTTC() { return editionTTC; }
	public double getEcoTaxe() { return ecoTaxe; }
	public double getTauxIndicatif() { return tauxIndicatif; }
	public boolean getAssujettiTVA() { return assujettiTVA; }
	public boolean getTVALiv() { return tvaLiv; }
	public String getNumTVAIntra() { return numTVAIntra; }
	public String getRegimeTVA() { return regimeTVA; }
	public String getMentions() { return mentions; }
	public long getDateDEB() { return dateDEB; }
	public long getDateEditionLot() { return dateEditionLot; }
	public long getDateEditionAuto() { return dateEditionAuto; }
	public String getModeEnvoiFacture() { return modeEnvoiFacture; }
	public long getDateEnvoi() { return dateEnvoi; }
	public int getVersCalc() { return versCalc; }
	public HashMap<Integer, LigneFacture> getLignesFacture() { return lignesFacture; }
	

} // fin Facture
