/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.data.dossier;

import java.util.HashMap;

import org.opensi.data.dossier.Adresse;
import org.opensi.data.dossier.Contact;


public class Devis implements org.opensi.api.DataOSI {
	
	
	private int devisId;
	private int numero;
	private String numEntier;
	private String intitule;
	private long dateDevis;
	private long dateExp;
	private String etat;
	private long dateValidation;
	private boolean editionTTC;
	private String clientId;
	private int codeTarif;
	private int utilC;
	private int utilM;
	private int utilR;
	private long dateC;
	private long dateM;
	private Adresse adresseFact;
	private Contact contactFact;
	private Adresse adresseLiv;
	private Contact contactLiv;
	private Adresse adresseEnvoi;
	private Contact contactEnvoi;
	private boolean assujettiTVA;
	private String numTVAIntra;
	private String regimeTVA;
	private int versCalc;
	private double remise;
	private double montantRemise;
	private double escompte;
	private double acompte;
	private double fraisPort;
	private double pRemiseFP;
	private double mRemiseFP;
	private int codeTVAPort;
	private double tauxTVAPort;
	private double totalHT;
	private double totalTTC;
	private String mentions;
	private String commentairesFin;
	private String commentairesInt;
	private String commentairesHid;
	private HashMap<Integer, LigneDevis> lignesDevis;

	public Devis(int devisId,
				int numero,
				String numEntier,
				String intitule,
				long dateDevis,
				long dateExp,
				String etat,
				long dateValidation,
				boolean editionTTC,
				String clientId,
				int codeTarif,
				int utilC,
				int utilM,
				int utilR,
				long dateC,
				long dateM,
				Adresse adresseFact,
				Contact contactFact,
				Adresse adresseLiv,
				Contact contactLiv,
				Adresse adresseEnvoi,
				Contact contactEnvoi,
				boolean assujettiTVA,
				String numTVAIntra,
				String regimeTVA,
				int versCalc,
				double remise,
				double montantRemise,
				double escompte,
				double acompte,
				double fraisPort,
				double pRemiseFP,
				double mRemiseFP,
				int codeTVAPort,
				double tauxTVAPort,
				double totalHT,
				double totalTTC,
				String mentions,
				String commentairesFin,
				String commentairesInt,
				String commentairesHid) {
		
		this.devisId = devisId;
		this.numero = numero;
		this.numEntier = numEntier;
		this.intitule = intitule;
		this.dateDevis = dateDevis;
		this.dateExp = dateExp;
		this.etat = etat;
		this.dateValidation = dateValidation;
		this.editionTTC = editionTTC;
		this.clientId = clientId;
		this.codeTarif = codeTarif;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.dateC = dateC;
		this.dateM = dateM;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.adresseLiv = adresseLiv;
		this.contactLiv = contactLiv;
		this.adresseEnvoi = adresseEnvoi;
		this.contactEnvoi = contactEnvoi;
		this.assujettiTVA = assujettiTVA;
		this.numTVAIntra = numTVAIntra;
		this.regimeTVA = regimeTVA;
		this.versCalc = versCalc;
		this.remise = remise;
		this.montantRemise = montantRemise;
		this.escompte = escompte;
		this.acompte = acompte;
		this.fraisPort = fraisPort;
		this.pRemiseFP = pRemiseFP;
		this.mRemiseFP = mRemiseFP;
		this.codeTVAPort = codeTVAPort;
		this.tauxTVAPort = tauxTVAPort;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		this.mentions = mentions;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.commentairesHid = commentairesHid;
	}
	
	
	public boolean isValid() {
	
		return true;
	}
	
	
	public void addLigne(int ligneId, LigneDevis ligneDevis) { this.lignesDevis.put(ligneId, ligneDevis); }
	
	public int getDevisId() { return devisId; }
	public int getNumero() { return numero; }
	public String getNumEntier() { return numEntier; }
	public String getIntitule() { return intitule; }
	public long getDateDevis() { return dateDevis; }
	public long getDateExp() { return dateExp; }
	public String getEtat() { return etat; }
	public long getDateValidation() { return dateValidation; }
	public boolean getEditionTTC() { return editionTTC; }
	public String getClientId() { return clientId; }
	public int getCodeTarif() { return codeTarif; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM;	}
	public int getUtilR() { return utilR; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public Contact getContactLiv() { return contactLiv; }
	public Adresse getAdresseEnvoi() { return adresseEnvoi; }
	public Contact getContactEnvoi() { return contactEnvoi; }
	public boolean getAssujettiTVA() { return assujettiTVA; }
	public String getNumTVAIntra() { return numTVAIntra; }
	public String getRegimeTVA() { return regimeTVA; }
	public int getVersCalc() { return versCalc; }
	public double getRemise() { return remise; }
	public double getMontantRemise() { return montantRemise; }
	public double getEscompte() { return escompte; }
	public double getAcompte() { return acompte; }
	public double getFraisPort() { return fraisPort; }
	public double getPRemiseFP() { return pRemiseFP; }
	public double getMRemiseFP() { return mRemiseFP; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public String getMentions() { return mentions; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getCommentairesHid() { return commentairesHid; }
	public HashMap<Integer, LigneDevis> getLignesDevis() { return lignesDevis; }
	

} // fin Devis
