/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import de donnes comptables Agave
 */

package org.opensi.compta.actions.transferts;


import java.io.BufferedReader;
import java.io.FileReader;

import org.opensi.util.tools.Arrondi;
import org.opensi.util.tools.DateTime;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.data.dossier.Compte;

import org.opensi.api.SessionOSI;


public class ImportAgave extends ImportCompta {


	public ImportAgave(SessionOSI sosi, String base, String fichierImport, String journal) {
		
		super(sosi, base, fichierImport, journal);
	}


	public void importer() throws Exception {
	
		Arrondi rd = new Arrondi(2);

		Ecriture currentEcr = null;
		int currentSum = 0;
		int currentLine = 0;

		FileReader fr = new FileReader(fichier);

		BufferedReader br = new BufferedReader(fr);

		// 2 lignes d'entete
		if (br.ready()) {br.readLine();currentLine++;}
		if (br.ready()) {br.readLine();currentLine++;}

		while (br.ready()) {

			String line = br.readLine();
			cc.incLine();
			currentLine++;
			
			line+=";";
			String [] elem = splitmanuel(line,12);
			
			
			String numeroCompte = elem[7].trim();
			String intitule = numeroCompte;
			
			String type = (numeroCompte.startsWith("C")?"C":(numeroCompte.startsWith("F")?"F":"G"));
			
			if (!type.equals("G"))
				numeroCompte = "0"+ numeroCompte;
				
			numeroCompte = completeWith0(numeroCompte);

			cc.checkIntituleCompte(intitule);

			if (cc.checkTypeCompte(type)) {				
				cc.checkNumeroCompte(numeroCompte, type);
			}

			Compte compte = new Compte();
			compte.setNumeroCompte(numeroCompte);
			compte.setIntitule(intitule);
			compte.setTypeCompte(type);

			comptes.put(numeroCompte.toLowerCase(), compte);

			if (currentSum==0) {

				String codeJournal = elem[0].trim();
				long dateEcriture = (new DateTime(1,Integer.parseInt(elem[4].trim()),Integer.parseInt(elem[3].trim()))).getDateInMillis();
				
				// souci des a nouveaux
				if (dateEcriture<debutExercice) {
					dateEcriture = periodeDebutExercice;
				}		

				cc.checkCodeJournal(codeJournal);
				cc.checkPeriode(dateEcriture);

				currentEcr = new Ecriture();
				currentEcr.setCodeJournal(codeJournal);
				currentEcr.setDateEcriture(dateEcriture);

				ecritures.addEcriture(currentEcr);
			}


			long dateOp = (new DateTime(Integer.parseInt(elem[5].trim()),Integer.parseInt(elem[4].trim()),Integer.parseInt(elem[3].trim()))).getDateInMillis();
			
			String libelle = elem[8].trim();
			String compteAna = elem[9].trim();

			double montantD = 0;
			double montantC = 0;
			String numPiece = elem[6].trim();
											
			montantC = Double.parseDouble(elem[11].trim());
			if (montantC>0)
				cc.checkMontantOp(montantC);

			
			montantD = Double.parseDouble(elem[10].trim());
			if (montantD>0)
				cc.checkMontantOp(montantD);

			currentSum += montantD - montantC;


			cc.checkDateOp(dateOp);
			cc.checkLibelleOp(libelle);
			cc.checkNumeroCompte(numeroCompte);			
			
			Operation op = new Operation();
			op.setDateOp(dateOp);
			op.setLibelle(libelle);
			op.setNumeroCompte(numeroCompte);
			op.setMontantD(montantD);
			op.setMontantC(montantC);
			op.setNumPiece(numPiece);
			op.setCommentaire(compteAna);
			
			currentEcr.addOperation(op);																		
		}

		br.close();
	}
	

} // fin ImportAgave



