/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Sauvegarde dans la BD des modifs
 */

package org.opensi.compta.actions.tableauDeBord;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;



public class sauvegarde extends Action {

	String listeParam;
	String[] touteLaListe;
	String[] listeCompte;
	String[] listeValeur;
	String[] listeDate;
	int nbLignes;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		Connection con = s.getConnection(null);

		String base = s.getCookie().get("BaseDossier");
		
		listeParam = r.getParameter("Liste");
		String choix = r.getParameter("Choix");

		if (!listeParam.equals("")) {
			separerLaListe();
		}


		//suppression de l'existant
		String requeteDel = "delete from "+ base +".SAUVEGARDE "+ whereDeleteDapresChoix(choix.charAt(0));

		Statement stt1 = con.createStatement();
		stt1.execute(requeteDel);

		if (!listeParam.equals("")) {

			String requetInsert = "insert into "+base+".SAUVEGARDE values (?,?,?)";
			PreparedStatement stt2 = con.prepareStatement(requetInsert);

			for (int g=0; g<nbLignes;g++)	{
				stt2.setString(1, listeCompte[g]);
				stt2.setLong(2, Long.parseLong(listeDate[g]));
				stt2.setInt(3, Integer.parseInt(listeValeur[g]));
				stt2.executeUpdate();
			}
		}
		
		return true;
	}
	
	
	public void separerLaListe() {

		//on enlve la premire ','
		listeParam=listeParam.substring(1);

		touteLaListe=listeParam.split(",",0);

		nbLignes=touteLaListe.length/3;

		listeCompte=new String[nbLignes];
		listeValeur=new String[nbLignes];
		listeDate=new String[nbLignes];

		for (int i=0; i<nbLignes; i++) {

			listeCompte[i]=touteLaListe[i*3];
			listeDate[i]=touteLaListe[i*3+1];
			listeValeur[i]=touteLaListe[i*3+2];
		}
	}
	
	
	public String whereDeleteDapresChoix(char lettreChoix) {
		
		String resultat = "";
		conditionsComptes condition = new conditionsComptes();
		
		switch (lettreChoix) {
			case 'P': resultat = " WHERE "+ condition.chargesDePersonnel("");	break;		
			case 'E':	resultat = " WHERE "+ condition.chargesExternes("");		break;		
			case 'F':	resultat = " WHERE "+ condition.chargesFinancieres("");	break;
			case 'A':	resultat = " WHERE "+ condition.amortissements("");			break;
			case 'I':	resultat = " WHERE "+ condition.impotsEtTaxes("");			break;			
			case 'C':	resultat = " WHERE "+ condition.chiffreDAffaires("");   break;
			default: resultat = "";
		}
		
		return resultat;
	}
	
}
