/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Cre le tableau en Ooo
 */

package org.opensi.compta.actions.suiviActivite;

import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.openoffice.CreateurOpenOffice;
import org.opensi.util.openoffice.OooCellule;
import org.opensi.util.openoffice.OooLigne;
import org.opensi.util.openoffice.OooStyleCellule;


public class budgetTabVersOoo extends Action 
{


	String chemin;
	String nomFichier;
	int nbMois, decalage;
		
	CreateurOpenOffice zeus;
	OooStyleCellule titreStyle, titreNombreStyle, caseStyle;
	String titre;

	String liste;
	String [] tabLib;
	String [][] tabPrevu; //[lib][mois]
	String [][] tabActu; //[lib][mois]
	String [][] tabRetenu; //[lib][mois]
	int []tabTotaux, tabPourcent;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception 
	{

	
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		
	
		nomFichier=r.getParameter("fichierSxc");
		liste=r.getParameter("liste");
		nbMois=Integer.parseInt(r.getParameter("nbMois"));
		decalage=Integer.parseInt(r.getParameter("decal"));
		titre="Budget";


		separerLaListe();
		calculeTotaux();
		calculePourcents();

		genererOoo();
		
		return true;
	
	}
	
	public void calculePourcents()
	{
		
			int somme=0;
			int chiffre;

			for(int y=0; y<tabTotaux.length;y++)
			{
				somme+=tabTotaux[y];
			}

			tabPourcent=new int[tabTotaux.length];

			for(int w=0; w<tabTotaux.length;w++)
			{
				chiffre=tabTotaux[w];
				tabPourcent[w]=chiffre*100/somme;
			}
	
	}
	
	public void separerLaListe()
	{
		
		
		//On enlve le premier ';'
		liste=liste.substring(1);
		String[] parLib=liste.split(";");
		
		
		tabLib=new String[parLib.length];
		tabPrevu=new String[parLib.length][nbMois];
		tabActu=new String[parLib.length][nbMois];
		tabRetenu=new String[parLib.length][nbMois];
		
		
		
		
		for( int lib=0; lib<parLib.length;lib++)
		{
			String temp=new String(parLib[lib]);
			
			String [] laLigne=temp.split("_");

			tabLib[lib]=new String(laLigne[0]);
			String prevuTemp=laLigne[1];
			String actuTemp=laLigne[2];
			String retenuTemp=laLigne[3];
			
			//On enlve la premire ','
			prevuTemp=prevuTemp.substring(1);
			actuTemp=actuTemp.substring(1);
			retenuTemp=retenuTemp.substring(1);
			
			String [] tabPrevuTemp=prevuTemp.split(",");
			String [] tabActuTemp=actuTemp.split(",");
			String [] tabRetenuTemp=retenuTemp.split(",");
			
		

			for(int mois=0; mois<nbMois;mois++)
			{
				tabPrevu[lib][mois]=tabPrevuTemp[mois];
				tabActu[lib][mois]=tabActuTemp[mois];
				tabRetenu[lib][mois]=tabRetenuTemp[mois];
			}


		
		}
	}
	

	public void calculeTotaux()
	{
		int total=0;
		
		
			tabTotaux=new int [tabLib.length];
			for(int i=0; i<tabLib.length;i++)
			{
				total=0;
				for (int a=0; a<nbMois;a++)
				{
					total+=	Integer.parseInt(tabRetenu[i][a]);
				}
				
				
				tabTotaux[i]=total;
			
			}
		
	}
	
	
	/* *************** GENERATION Ooo ************************ */
	
	public void genererOoo()
	{
	

		zeus=new CreateurOpenOffice(chemin+"/openoffice");

		creerLesStyles();
		genererEntete();
		ecrireContenu();
		ecrireLigneTotal();
		
		zeus.changerLargeurColonne(0,6.0f);
		zeus.changerLargeurColonne(2,1.3f);
		
		File fichier=zeus.genererDocument(nomFichier);
		fichier.deleteOnExit();

		
	}
	
	
	
	/**
	* Ecris les deux lignes d'entte
	**/
	public void genererEntete()
	{
	
	
		OooLigne ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());
		OooCellule truc;


		//*************** 1re ligne ******************
		for (int h=0; h<3; h++)
		{
			//espacement, au dessus du tableau de gauche
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
		}
		
		
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			
			int mois12=((g+decalage)%12)+1;
			
			
			truc=new OooCellule(leMois(mois12), titreStyle);
			truc.setFusion(1, 3);
			ligneEnTete.ajouterCellule(truc);
	
		}
		
		
		zeus.ajouterLigne(ligneEnTete);

		// ********** 2me ligne ***************
		ligneEnTete=new OooLigne(zeus.getStyleLigneParDefaut());


		//tableau de gauche:
		truc=new OooCellule(titre, titreStyle);

		truc.setFusion(1, 3);
		ligneEnTete.ajouterCellule(truc);
		for (int g=0; g<nbMois;g++)
		{
			//espacement
			truc=new OooCellule("", zeus.getStyleCelluleParDefaut());
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Prev", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Actu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			truc=new OooCellule("Retenu", titreStyle);
			ligneEnTete.ajouterCellule(truc);
			
		}
		

		zeus.ajouterLigne(ligneEnTete);
		

	}
	
	
	
	public void ecrireContenu()
	{
	
			OooCellule vide=new OooCellule("",zeus.getStyleCelluleParDefaut());
			OooCellule caseVide=new OooCellule("",caseStyle);
			OooLigne enCours;
			OooCellule enCoursAussi;
			String temp;
			int nombre;
			
			for (int lib=0; lib<tabLib.length;lib++)
			{
				enCours=new OooLigne(zeus.getStyleLigneParDefaut());
				
				//Libell
				enCoursAussi=new OooCellule(tabLib[lib],caseStyle);
				enCours.ajouterCellule(enCoursAussi);
				
				//Total
				enCoursAussi=new OooCellule(tabTotaux[lib],caseStyle);
				enCours.ajouterCellule(enCoursAussi);
				
				//pourcent
				temp=""+tabPourcent[lib]+" %";
				enCoursAussi=new OooCellule(temp,caseStyle);
				enCours.ajouterCellule(enCoursAussi);

				for (int mois=0; mois<nbMois;mois++)
				{
					
					//Prevu
					enCours.ajouterCellule(vide);
					nombre=Integer.parseInt(tabPrevu[lib][mois]);
					enCoursAussi=new OooCellule(nombre,caseStyle);
					enCours.ajouterCellule(enCoursAussi);

					temp=tabActu[lib][mois];
					//Actu
					if(temp.equals("rien"))
					{
						enCours.ajouterCellule(caseVide);
					}
					else
					{
						nombre=Integer.parseInt(tabActu[lib][mois]);
						enCoursAussi=new OooCellule(nombre,caseStyle);
						enCours.ajouterCellule(enCoursAussi);
					}
					

					//Retenu
					nombre=Integer.parseInt(tabRetenu[lib][mois]);
					enCoursAussi=new OooCellule(nombre,caseStyle);
					enCours.ajouterCellule(enCoursAussi);
				}

				zeus.ajouterLigne(enCours);	

			}
	
		
	}
	
	
	public void ecrireLigneTotal()
	{

			OooCellule vide=new OooCellule("",zeus.getStyleCelluleParDefaut());
			OooLigne enCours;
			OooCellule enCoursAussi;
	
			long sommeActu, sommePrevu, sommeRetenu, total;
			String temp;
	
	
			enCours=new OooLigne(zeus.getStyleLigneParDefaut());
	
			//1.Le total de gauche
			total=0;
			for(int lib=0; lib<tabLib.length;lib++)
				{
						total+=tabTotaux[lib];
				}
				enCoursAussi=new OooCellule("Total:",titreStyle);
				enCours.ajouterCellule(enCoursAussi);
				
				enCoursAussi=new OooCellule(total,titreNombreStyle);
				enCours.ajouterCellule(enCoursAussi);
				
				enCoursAussi=new OooCellule("100 %",titreStyle);
				enCours.ajouterCellule(enCoursAussi);

			for (int mois=0; mois<nbMois;mois++)
			{
				sommeActu=0;
				sommePrevu=0;
				sommeRetenu=0;
				
				for(int lib=0; lib<tabLib.length;lib++)
				{
						temp=tabActu[lib][mois];
	
						
						if(!temp.equals("rien"))
						{
							
							sommeActu+=Integer.parseInt(tabActu[lib][mois]);
						}
						sommePrevu+=Integer.parseInt(tabPrevu[lib][mois]);

						sommeRetenu+=Integer.parseInt(tabRetenu[lib][mois]);
		
				}
				
				enCours.ajouterCellule(vide);

				enCoursAussi=new OooCellule(sommePrevu,titreNombreStyle);

				enCours.ajouterCellule(enCoursAussi);
				
				enCoursAussi=new OooCellule(sommeActu,titreNombreStyle);
			
				enCours.ajouterCellule(enCoursAussi);
			
				enCoursAussi=new OooCellule(sommeRetenu,titreNombreStyle);
			
				enCours.ajouterCellule(enCoursAussi);
		
			}		
	
		zeus.ajouterLigne(enCours);
	
	}
	
	
	public void creerLesStyles()
	{

		titreStyle=zeus.creerNewStyleCellule();
		titreStyle.setGras(true); 
		titreStyle.setCouleurFond("#FCD9AF");
		titreStyle.setBordure(true);
		titreStyle.setAlignement(OooStyleCellule.H_CENTRE,OooStyleCellule.V_MILIEU);
		titreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		titreNombreStyle=zeus.creerNewStyleCellule();
		titreNombreStyle.setGras(true); 
		titreNombreStyle.setCouleurFond("#FCD9AF");
		titreNombreStyle.setBordure(true);
		titreNombreStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
		caseStyle=zeus.creerNewStyleCellule();
		caseStyle.setBordure(true);
		caseStyle.setFormatNombre(OooStyleCellule.FORMAT_NOMBRE_ENTIER);
		
	}
	
	

	
	public String leMois(int lemois)
	{
		String resultat="";
		
		switch (lemois)
		{
			case 1: resultat="Janvier";break;
			case 2: resultat="Fvrier";break;
			case 3: resultat="Mars";break;
			case 4: resultat="Avril";break;
			case 5: resultat="Mai";break;
			case 6: resultat="Juin";break;
			case 7: resultat="Juillet";break;
			case 8: resultat="Aout";break;
			case 9: resultat="Septembre";break;
			case 10: resultat="Octobre";break;
			case 11: resultat="Novembre";break;
			case 12: resultat="Dcembre";break;
			default: resultat="";
		
		}
		
		return resultat;
	}


	
	
}



		
			
			










