package org.opensi.compta.actions.rapprochementBancaire;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


public class CollectionRapprochement {
	
	Connection con = null;
	private String basedossier;
	private String base;
	private String typeRappro="";
	private String codeJournal;
	private String compte;

	public CollectionRapprochement(Connection con, String basedossier, String base) {
		this.con=con;		
		this.basedossier=basedossier;
		this.base=base;
	}
	public String getTypeRappro() {
		return typeRappro;
	}
	public void setTypeRappro(String typeRappro) {
		this.typeRappro = typeRappro;
	}
	public String getCodeJournal() {
		return codeJournal;
	}
	public void setCodeJournal(String codeJournal) {
		this.codeJournal = codeJournal;
	}
	
	
	//raz des rapprochements pour un compte ou un journal
	public void supprimerRappros() {		
		 try {
			 
				PreparedStatement pstmt = null;
				String SELECT_BASES = "SELECT distinct Nom_Base, Debut_Exercice, Fin_Exercice from "+ basedossier +".EXERCICE";
			    pstmt = con.prepareStatement(SELECT_BASES);
			    ResultSet rs = pstmt.executeQuery();
				    while (rs.next()){
				    	String baseexo="";
				    	baseexo=rs.getString(1);				    
				    	PreparedStatement pstmt2 = null;
				    	String SELECT_RAPPROID ="";
				    	if (typeRappro.equals("C")){
				    		SELECT_RAPPROID =
					            "SELECT Rappro_Id from  " + basedossier +".RAPPROCHEMENT r where Date_Rappro BETWEEN ? and ? and Numero_Compte=?";
							pstmt2 = con.prepareStatement(SELECT_RAPPROID);
							pstmt2.setLong(1, rs.getLong(2)); 
							pstmt2.setLong(2, rs.getLong(3)); 
							pstmt2.setString(3, compte); 
						}
				    	
						if (typeRappro.equals("J")){
							SELECT_RAPPROID =
					            "SELECT Rappro_Id from  " + basedossier +".RAPPROCHEMENT r where Date_Rappro BETWEEN ? and ? and Code_Journal=?";
							pstmt2 = con.prepareStatement(SELECT_RAPPROID);
							pstmt2.setLong(1, rs.getLong(2)); 
							pstmt2.setLong(2, rs.getLong(3)); 
							pstmt2.setString(3, codeJournal); 
							
						}
					 					
						ResultSet rs2 = pstmt2.executeQuery();
					    while (rs2.next()){
					      int rapproid=rs2.getInt(1);	
					      
					  
					      base=baseexo;
					      if (typeRappro.equals("J")){
					    	 
					    	  DeletePointageOperationsRapprojournal(codeJournal);	  
					      }
					      if (typeRappro.equals("C")){
					    	  
					    	  DeletePointageOperationsRapproCompte(compte);	
					      }						    
					  	  Rapprochement rappro=new Rapprochement(rapproid,con,baseexo,basedossier);
					  	  rappro.loadRappro(rapproid);					  
					  	  rappro.supprimerRappro();
					    }
				    }
				 
		 }
		 
		 catch (SQLException sqle) {		    	
		    	sqle.printStackTrace();
		    }
    
    
	}
	public void DeletePointageOperationsRappro(int rapproid) {
		 PreparedStatement pstmt = null;
		 try {
			 String DELETE_POINTAGE =			
			 "UPDATE "+ base +".OPERATION set Pointage=0  where Op_Id IN (select Op_Id from "+ basedossier +".LIGNE_RAPPROCHEMENT where  Rappro_Id=?)";
		     pstmt = con.prepareStatement(DELETE_POINTAGE);   	 
			 pstmt.setLong(1, rapproid); 
			 pstmt.executeUpdate();		  
		 }
		 
		 catch (SQLException sqle) {		    
		    	sqle.printStackTrace();
		    }
	 	}
	
	public void DeletePointageOperationsRapproCompte(String compte) {
		 PreparedStatement pstmt = null;
		 try {
			 String DELETE_POINTAGE =			
			 "UPDATE "+ base +".OPERATION set Pointage=0  where Numero_Compte =?";
		     pstmt = con.prepareStatement(DELETE_POINTAGE);   	 
			 pstmt.setString(1, compte); 			
			 pstmt.executeUpdate();		  
		 }
		 
		 catch (SQLException sqle) {
		    	
		    	sqle.printStackTrace();
		    }
	 	}
	public void DeletePointageOperationsRapprojournal(String codeJournal) {
		 PreparedStatement pstmt = null;
		 try {
			 String DELETE_POINTAGE =			
			 "UPDATE "+ base +".OPERATION o LEFT JOIN "+ base +".ECRITURE e on e.Ecriture_Id=o.Ecriture_Id set o.Pointage=0 where e.Code_Journal=?";
		     pstmt = con.prepareStatement(DELETE_POINTAGE);   	 
			 pstmt.setString(1, codeJournal); 
			 pstmt.executeUpdate();			
		 }
		
		 catch (SQLException sqle) {		    	
		    	sqle.printStackTrace();
		    }
	 	}
	public String getCompte() {
		return compte;
	}
	public void setCompte(String compte) {
		this.compte = compte;
	}	
	
	
}
