/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Gnration du graphique de rpartition des SIG
 */

package org.opensi.compta.actions.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.io.File;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.ui.RectangleInsets;


public class CamembertSIG extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		//BasicConfigurator.configure();
		
		String nomFichier = r.getParameter("fichierPng");
		
		int sigVM = Integer.parseInt(unspace(r.getParameter("VM")));
		int sigPE = Integer.parseInt(unspace(r.getParameter("PE")));
		int sigMBG = Integer.parseInt(unspace(r.getParameter("MBG")));
		int sigVA = Integer.parseInt(unspace(r.getParameter("VA")));
		int sigEBE = Integer.parseInt(unspace(r.getParameter("EBE")));
		int sigRE = Integer.parseInt(unspace(r.getParameter("RE")));
		
		DefaultPieDataset data = new DefaultPieDataset();
		data.setValue("VM", sigVM);
		data.setValue("PE", sigPE);
		data.setValue("MBG", sigMBG);
		data.setValue("VA", sigVA);
		data.setValue("EBE", sigEBE);
		data.setValue("RE", sigRE);
		
		PiePlot plot = new PiePlot(data);
		plot.setInsets(new RectangleInsets(1, 1, 1, 1));
		plot.setIgnoreZeroValues(false);
		plot.setIgnoreNullValues(false);
		JFreeChart chart = new JFreeChart("Rpartition des SIG", JFreeChart.DEFAULT_TITLE_FONT, plot, true);
		
		Paint couleur_fond = new Color(255,255,255,0); //transparent
		chart.setBackgroundPaint(couleur_fond);
		
		//La lgende
			
		//LegendTitle legende_chart =new LegendTitle(plot);

		/*FlowArrangement arrangement=new FlowArrangement();
		BlockContainer conteneur=new BlockContainer(arrangement);
		
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(0)),"VM");
		conteneur.add(new LabelBlock("VM  "));
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(1)),"PE");
		conteneur.add(new LabelBlock("PE  "));
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(2)),"MBG");
		conteneur.add(new LabelBlock("MBG  "));
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(3)),"VA");
		conteneur.add(new LabelBlock("VA  "));
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(4)),"EBE");
		conteneur.add(new LabelBlock("EBE  "));
		conteneur.add(new LegendGraphic(Plot.DEFAULT_LEGEND_ITEM_CIRCLE, plot.getSectionPaint(5)),"RE");
		conteneur.add(new LabelBlock("RE"));
		
		CompositeTitle legende=new CompositeTitle();
		legende.setTitleContainer(conteneur);
		chart.clearSubtitles() ;
		legende.setPosition(RectangleEdge.BOTTOM);
		legende.setBorder(new BlockBorder(1,1,1,1));
		chart.addSubtitle(legende);*/
		
		chart.clearSubtitles() ;
		
		try {
			
			String chemin = s.getAppConfiguration().get("opensi.absdir") + "/graph/";
			File file = new File(chemin + nomFichier);
		
			ChartUtilities.saveChartAsPNG(file, chart, 430, 315, null, true, 9);
		
			file.deleteOnExit();		
		}
		catch(SecurityException se) {
    	s.trace("Impossible d'enregistrer le fichier  supprimer");
    	se.printStackTrace();
    }		
		catch (Exception e) {
			e.printStackTrace();
		}
		
		
		return true;			
	}

	
	// enleve les caracteres -1 de la chaine
	private String unspace(String str) {

		String strUnspace = "";
		char c;

		for (int i=0;i<str.length();i++) {
			c = str.charAt(i);		
			strUnspace += Character.getNumericValue(c)==-1?"":Character.toString(c);
		}

		return strUnspace;
	}


} // fin CamembertSIG
