/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un tat d'avancement
 */

package org.opensi.compta.actions.etats;


import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;


public class GenEtatAvancement extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  	String fichier = r.getParameter("Fichier");
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String sortie = r.getParameter("Sortie");
		String typeExercice = r.getParameter("Exercice");
		
		DataEtatAvancement dea = new DataEtatAvancement(s, typeExercice);
		
		if (sortie.equals("PDF")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
			
			GlobalDocument gd = new GlobalDocument(repPdf, fichier);
			
			EtatAvancementStd etat = new EtatAvancementStd(repTemp, dea);
		
			gd.addInternal(etat);
			
			gd.close(GlobalDocument.ON_EXIT);
		} else if (sortie.equals("CSV")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvEtatAvancement(buffer, fichier, dea);
		}
	
		return true;
		
	} // fin service


} // fin GenEtatAvancement
