/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.bo.commandeclient;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.opensi.api.SessionOSI;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.facturation.reglements.clients.MajStatutCommandes;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.tools.DateTime;


public class BOCommandeClient {

	private Connection con;
	private String baseDossier;
	
	
	public BOCommandeClient(SessionOSI sosi) {
		this(sosi.getConnection(), sosi.getBaseDossier());
	}


	public BOCommandeClient(Connection con, String baseDossier) {
		this.con = con;
		this.baseDossier = baseDossier;
	}

	public void majTotaux(int commandeClientId) throws SQLException {
		Calcul calc = new Calcul (con,baseDossier);
		calc.setDocument(commandeClientId, "Commande");
		calc.majTotaux();
	}

	public void majTotauxBLs(int commandeClientId) throws SQLException {
		PreparedStatement psFact = con.prepareStatement("select Bon_Id from "+ baseDossier +".BON_LIVRAISON where Commande_Id=?");
		psFact.setInt(1, commandeClientId);
		ResultSet rset = psFact.executeQuery();
		while (rset.next()) {
			Calcul calc = new Calcul (con,baseDossier);
			calc.setDocument(rset.getInt("Bon_Id"), "Bon_Livraison");
			calc.majTotaux();
		}
		psFact.close();
	}
		
	public void majStatuts(int commandeClientId, int user) throws SQLException {
		majStatutLivraison(commandeClientId);
		majStatutFacture(commandeClientId, user);
	}

	public void majStatuts(int commandeClientId) throws SQLException {
		majStatutLivraison(commandeClientId);
		majStatutFacture(commandeClientId, 0);
	}
	
	private void majStatutLivraison(int commandeClientId) throws SQLException {
		// maj livree
		PreparedStatement psFact = con.prepareStatement("select Ligne_Id, Quantite from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Commande_Id=? and Statut='V'");
		psFact.setInt(1, commandeClientId);
		ResultSet rset = psFact.executeQuery();
		int soldee = 1;
		while (rset.next()) {
			int ligneId = rset.getInt("Ligne_Id");
			majLigneStatutLivraison(ligneId);
			if (getLigneQuantiteLivree(ligneId)<rset.getDouble("Quantite")) {
				soldee = 0;
			}
		}
		PreparedStatement psUpFact = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set Soldee=? where Commande_Id=?");
		psUpFact.setInt(1, soldee);
		psUpFact.setInt(2, commandeClientId);
		psUpFact.executeUpdate();
		
		psFact.close();
		psUpFact.close();
	}

	private void majLigneStatutLivraison(int ligneId) throws SQLException {
		// maj livree ligne
		PreparedStatement psUpFact = con.prepareStatement("update "+ baseDossier +".LIGNE_COMMANDE_CLIENT set Soldee=? where Ligne_Id=?");
		PreparedStatement psFact = con.prepareStatement("select Quantite from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Ligne_Id=? and Statut='V'");
		psFact.setInt(1, ligneId);
		ResultSet rset = psFact.executeQuery();
		while (rset.next()) {
			psUpFact.setInt(1, getLigneQuantiteLivree(ligneId)<rset.getDouble("Quantite")?0:1);
			psUpFact.setInt(2, ligneId);
			psUpFact.executeUpdate();
		}
		
		psUpFact.close();
		psFact.close();
	}

	/* met a jour les statuts pour une commandeId donne
	 * utilisateur mettant a jour la fiche
	 */
	public void majStatutFacture(int commandeClientId, int user) throws SQLException {
		// maj facturee
		PreparedStatement psFact = con.prepareStatement("select Ligne_Id, Quantite from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Commande_Id=? and Statut='V'");
		psFact.setInt(1, commandeClientId);
		ResultSet rset = psFact.executeQuery();
		PreparedStatement psModeFact = con.prepareStatement("select Soldee,Mode_Facturation from "+ baseDossier +".AFFAIRE a join "+ baseDossier +".COMMANDE_CLIENT cc on a.Affaire_Id=cc.Affaire_Id where Commande_Id=?");
		psModeFact.setInt(1, commandeClientId);
		ResultSet rsetModeFact = psModeFact.executeQuery();
		int facturee = 1;
		if(rsetModeFact.next()) {
			int soldee = rsetModeFact.getInt("Soldee");
			while (rset.next()) {
				int ligneId = rset.getInt("Ligne_Id");
				if (rsetModeFact.getString("Mode_Facturation").equals("C")) {
					if (getLigneQuantiteFacturee(ligneId)<rset.getDouble("Quantite")) {
						facturee = 0;
					}
				}
				else {
					if (getLigneQuantiteFacturee(ligneId)<getLigneQuantiteLivree(ligneId)) {
						facturee = 0;
					}
				}
			}
			Calcul calc = new Calcul (con,baseDossier);
			calc.setDocument(commandeClientId, "Commande");
			if (getFraisPortFacturee(commandeClientId)<calc.getMFraisPort()) {
				facturee = 0;
			}
			if (rsetModeFact.getString("Mode_Facturation").equals("E") && soldee==0) {
				facturee = 0;
			}

		}
		PreparedStatement psUpFact = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set Facturee=? where Commande_Id=?");
		psUpFact.setInt(1, facturee);
		psUpFact.setInt(2, commandeClientId);
		psUpFact.executeUpdate();

		// maj etat commande
		PreparedStatement psBR = con.prepareStatement("select brc.Bon_Id from "+ baseDossier +".BON_RETOUR_CLIENT brc join  "+ baseDossier +".BON_LIVRAISON bl on brc.BL_Id=bl.Bon_Id where brc.Etat in ('N','E') and bl.Commande_Id=?");
		psBR.setInt(1, commandeClientId);
		ResultSet rsetBR = psBR.executeQuery();
		if(rsetBR.next()) {}
		else {
			PreparedStatement psUpClo = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set Etat='C' where Commande_Id=? and Soldee=1 and Facturee=1");
			psUpClo.setInt(1, commandeClientId);
			psUpClo.executeUpdate();
		}
		
		// maj statut logistique
		PreparedStatement psUpLog = con.prepareStatement("update "+ baseDossier +".COMMANDE_CLIENT set Statut_Logistique=if(Etat='A',Statut_Logistique,if((Soldee=1),'E',if((Etat='T'),'T','N'))) where Commande_Id=?");
		psUpLog.setInt(1, commandeClientId);
		psUpLog.executeUpdate();

		// maj statut paiement
		MajStatutCommandes majStCom = new MajStatutCommandes(con, baseDossier);
		majStCom.traiterCommande(commandeClientId);
		majStCom.terminer();
		
		
		// maj etat affaire
		PreparedStatement psGetAff = con.prepareStatement("select Affaire_Id from "+ baseDossier +".COMMANDE_CLIENT where Commande_Id=?");
		PreparedStatement psGetCom = con.prepareStatement("select Commande_Id from "+ baseDossier +".COMMANDE_CLIENT where Etat='C' and Affaire_Id=?");
		PreparedStatement psGetComNonFinie = con.prepareStatement("select Commande_Id from "+ baseDossier +".COMMANDE_CLIENT where Etat not in ('C','A') and Affaire_Id=?");
		
		psGetAff.setInt(1, commandeClientId);
		ResultSet rsetGetAff = psGetAff.executeQuery();
		if(rsetGetAff.next()) {
			int affaireId = rsetGetAff.getInt("Affaire_Id");
			psGetCom.setInt(1, affaireId);
			ResultSet rsetGetCom = psGetCom.executeQuery();
			if(rsetGetCom.next()) {
				psGetComNonFinie.setInt(1, affaireId);
				ResultSet rsetGetComNonFinie = psGetComNonFinie.executeQuery();
				if(rsetGetComNonFinie.next()) {}
				else {
					long dateCourante = new DateTime().getTimeInMillis();
					PreparedStatement psUpCloAff = con.prepareStatement("update "+ baseDossier +".AFFAIRE set Etat='C', Date_M=?,Date_Cloture=?, Util_M=?  where Etat!='C' and Affaire_Id=?");
					psUpCloAff.setLong(1, dateCourante);
					psUpCloAff.setLong(2, dateCourante);
					psUpCloAff.setInt(3, (user==0)?null:user);
					psUpCloAff.setInt(4, affaireId);
					psUpCloAff.executeUpdate();
				}
			}
		}
		psFact.close();
		psModeFact.close();
		psUpFact.close();
		psBR.close();
		psUpLog.close();
		psGetAff.close();
		psGetCom.close();
		psGetComNonFinie.close();
	}

	public boolean isCloturee(CommandeClient commandeClient) throws SQLException {
		return commandeClient.getEtat().equals("C");
	}

	public int getNextRank(CommandeClient commandeClient) throws SQLException {
		
		int rank = 1;
		
		PreparedStatement psFact = con.prepareStatement("select max(Rank) as MaxRank from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Commande_Id=?");
		psFact.setInt(1, commandeClient.getCommandeId());
		ResultSet rset = psFact.executeQuery();
		if (rset.next()) {
			rank = rset.getInt("MaxRank")+1;
		}
		psFact.close();
		
		return rank;
	}

	public int getNbFacture(int commandeClientId) throws SQLException {
		
		int nbFact = 0;
		
		PreparedStatement psFact = con.prepareStatement("select count(*) as nb from "+ baseDossier +".FACTURE f join "+ baseDossier +".COMMANDE_CLIENT_FACTURE ccf on ccf.Facture_Id=f.Facture_Id where Numero<>0 and ccf.Commande_Id=?");
		psFact.setInt(1, commandeClientId);
		ResultSet rset = psFact.executeQuery();
		if (rset.next()) {
			nbFact = rset.getInt("nb");
		}
		
		psFact.close();
		
		return nbFact;		
	}

	public double getFraisPortFacturee(int commandeClientId) throws SQLException {
		double frais = 0;
		PreparedStatement psFact = con.prepareStatement("select ccf.Facture_Id, ccf.Frais_Port as Frais from "+ baseDossier +".FACTURE f join "+ baseDossier +".COMMANDE_CLIENT_FACTURE ccf on ccf.Facture_Id=f.Facture_Id where f.Numero<>0 and ccf.Commande_Id=?");
		psFact.setInt(1, commandeClientId);
		ResultSet rset = psFact.executeQuery();
		
		PreparedStatement psFactAv = con.prepareStatement("select sum(a.Frais_Port) as Frais from "+ baseDossier +".FACTURE_AVOIR fa join "+ baseDossier +".AVOIR a on fa.Avoir_Id=a.Avoir_Id where a.Numero<>0 and fa.Facture_Id=?");
		while (rset.next()) {
			psFactAv.setInt(1, rset.getInt("Facture_Id"));
			ResultSet rsetAv = psFactAv.executeQuery();
			if (rsetAv.next()) {
				frais+= rset.getDouble("Frais") - rsetAv.getDouble("Frais");
			}
			else {
				frais+= rset.getDouble("Frais");
			}
		}
		
		psFact.close();
		psFactAv.close();
		
		return frais;		
	}

	public boolean hasDocumentEnCours(int commandeClientId) throws SQLException {
		return hasBLEnCours(commandeClientId) || hasBREnCours(commandeClientId) || hasFactureEnCours(commandeClientId) || hasAvoirEnCours(commandeClientId);
	}
	
	public boolean hasBLEnCours(int commandeClientId) throws SQLException {
		
		boolean has = false;
		
		PreparedStatement psLiv = con.prepareStatement("select count(*) as nb from "+ baseDossier +".BON_LIVRAISON where Etat='N' and Commande_Id=?");
		psLiv.setInt(1, commandeClientId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			has = rset.getInt("nb")>0;
		}
		psLiv.close();
		
		return has;		
	}

	public boolean hasBREnCours(int commandeClientId) throws SQLException {
		
		boolean has = false;
		
		PreparedStatement psLiv = con.prepareStatement("select count(*) as nb from "+ baseDossier +".BON_RETOUR_CLIENT brc join "+ baseDossier +".BON_LIVRAISON bl on brc.BL_Id=bl.Bon_Id where brc.Etat='N' and bl.Commande_Id=?");
		psLiv.setInt(1, commandeClientId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			has = rset.getInt("nb")>0;
		}
		psLiv.close();
		
		return has;		
	}
	
	public boolean hasFactureEnCours(int commandeClientId) throws SQLException {
		
		boolean has = false;
		
		PreparedStatement psLiv = con.prepareStatement("select count(*) as nb from "+ baseDossier +".FACTURE f join "+ baseDossier +".COMMANDE_CLIENT_FACTURE ccf on ccf.Facture_Id=f.Facture_Id  where Numero=0 and ccf.Commande_Id=?");
		psLiv.setInt(1, commandeClientId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			has = rset.getInt("nb")>0;
		}
		psLiv.close();
		
		return has;		
	}

	public boolean hasAvoirEnCours(int commandeClientId) throws SQLException {
		
		boolean has = false;
		
		PreparedStatement psLiv = con.prepareStatement("select count(*) as nb from "+ baseDossier +".AVOIR a join "+ baseDossier +".FACTURE_AVOIR fa on a.Avoir_Id=fa.Avoir_Id join "+ baseDossier +".FACTURE f on f.Facture_Id=fa.Facture_Id join "+ baseDossier +".COMMANDE_CLIENT_FACTURE ccf on ccf.Facture_Id=f.Facture_Id  where a.Numero=0 and ccf.Commande_Id=?");
		psLiv.setInt(1, commandeClientId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			has = rset.getInt("nb")>0;
		}
		psLiv.close();
		
		return has;		
	}
	
	/* retourne la quantite livre pour un commandeId donne
	 * sinon -1
	 */
	public double getQuantiteLivree(int commandeId) throws SQLException {
	
		PreparedStatement psLiv = con.prepareStatement("select Ligne_Id from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Commande_Id=? and lcc.Statut='V'");
		psLiv.setInt(1, commandeId);
		ResultSet rset = psLiv.executeQuery();
		double total = 0;
		if (rset.next()) {
			total +=getLigneQuantiteLivree(rset.getInt("Ligne_Id"));
		}
		
		psLiv.close();
		
		return total;		
	}

	/* retourne la quantite livre pour un ligneId donn
	 * sinon -1
	 */
	public double getLigneQuantiteLivree(int ligneId) throws SQLException {
		
		double qteLiv = -1;
		
		PreparedStatement psLiv = con.prepareStatement("select coalesce(sum(Quantite_Livree),0) as Qte_Livree from " +
				"(select lbl.Ligne_Id, (lbl.Quantite - coalesce(sum(lbrc.Quantite),0)) as Quantite_Livree from "+
				baseDossier +".LIGNE_BON_LIVRAISON lbl join "+ baseDossier +".BON_LIVRAISON bl on lbl.Bon_Id=bl.Bon_Id and bl.Etat='V' and lbl.Statut='V'"+
				" left join "+ baseDossier +".LIGNE_BON_RETOUR_CLIENT lbrc on lbrc.Ligne_BL=lbl.Ligne_Id left join "+ baseDossier +".BON_RETOUR_CLIENT brc on lbrc.Bon_Id=brc.Bon_Id and brc.Etat='V'"
				+ " where lbl.Ref_Ligne=? group by lbl.Ligne_Id) as t");
		psLiv.setInt(1, ligneId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			qteLiv = (rset.getDouble("Qte_Livree")>=0)?rset.getDouble("Qte_Livree"):0;
		}
		psLiv.close();
		
		return qteLiv;
	}

	/* retourne la quantite restant a livrer pour un ligneId de commande donn
	 * sinon -1
	 */
	public double getLigneQuantiteRestantLivree(int ligneId) throws SQLException {
		
		double qteRest = -1;
		
		PreparedStatement psLiv = con.prepareStatement("select Quantite as commandee from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Ligne_Id=? and Statut='V'");
		psLiv.setInt(1, ligneId);
		ResultSet rset = psLiv.executeQuery();
		if (rset.next()) {
			double restant = rset.getDouble("commandee") - getLigneQuantiteLivree(ligneId);
			qteRest = (restant>0)?restant:0;
		}
		psLiv.close();
		
		return qteRest;
	}
	
	/* retourne la quantite facture pour un ligneId de commande donn
	 * sinon -1
	 */
	public double getLigneQuantiteFacturee(int ligneId) throws SQLException {
		/*PreparedStatement psFact = con.prepareStatement("select coalesce(sum(Quantite_Facturee),0) as Qte_Facturee from " +
				"(select lf.Ligne_Id, (lf.Quantite - coalesce(sum(la.Quantite),0)) as Quantite_Facturee from "+
				baseDossier +".LIGNE_FACTURE lf join "+ baseDossier +".FACTURE f on lf.Facture_Id=f.Facture_Id and f.Numero<>0" +
				" left join "+ baseDossier +".LIGNE_AVOIR la on lf.Ligne_Id=la.Ref_Ligne left join "+ baseDossier +".AVOIR a on la.Avoir_Id=a.Avoir_Id and a.Numero<>0"+
				" where lf.Ligne_Id=? group by lf.Ligne_Id) as t");
		*/
		
		double qteFact = -1;
		PreparedStatement psFact = con.prepareStatement("select coalesce(sum(Quantite_Facturee),0) as Qte_Facturee from " +
				"(select lf.Quantite as Quantite_Facturee from "+
				baseDossier +".LIGNE_FACTURE lf join "+ baseDossier +".FACTURE f on lf.Facture_Id=f.Facture_Id and f.Numero<>0" +
				" where lf.Ref_Ligne=?) as t");
		psFact.setInt(1, ligneId);
		ResultSet rset = psFact.executeQuery();
		if (rset.next()) {
			qteFact = rset.getDouble("Qte_Facturee");
		}
		psFact.close();
		return qteFact;		
	}
	
	public int getLigneCommandeId(int ligneId) throws SQLException {
		
		int commandeId = -1;
		
		PreparedStatement psLigCom = con.prepareStatement("select Commande_Id from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Ligne_Id=? and Statut='V' order by Rank");
		psLigCom.setInt(1, ligneId);
		ResultSet rsLC = psLigCom.executeQuery();
		if (rsLC.next()) {
			commandeId = rsLC.getInt("Commande_Id");
		}
		
		psLigCom.close();
		
		return commandeId;
	}
	
	

} // fin DBM_CommandeClient
