/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.dbm.dossier.DBM_ParamDossier;
import org.opensi.dbm.general.DBM_Dossier;
import org.opensi.dbm.exercice.DBM_PeriodeExercice;

import org.opensi.data.general.Dossier;
import org.opensi.data.dossier.ParamDossier;
import org.opensi.data.exercice.PeriodeExercice;

import org.opensi.util.tools.DateTime;
import org.opensi.util.tools.FileManager;
import org.opensi.util.sql.ScriptSQL;


public class CreateDossier implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
				
		String dossierId = param.getParameter("Dossier_Id");
		String nomDossier = param.getParameter("Nom");
		long debutExercice = param.getDateParameter("Debut_Exercice");
		long finExercice = param.getDateParameter("Fin_Exercice");		
		
		String baseDossier = "FACT_"+ dossierId;
		String baseExo = 	"CPTA_0_"+ dossierId;
		
		Statement stt = con.createStatement();
		stt.execute("create database "+ baseDossier);
		stt.execute("create database "+ baseExo);		
	
		ScriptSQL ssql = new ScriptSQL(con);	
		
		ssql.execute(sosi.getDatabaseDirectory() +"SchemaDossier.sql", baseDossier);
		ssql.execute(sosi.getDatabaseDirectory() +"InitDossier.sql", baseDossier);
		ssql.execute(sosi.getDatabaseDirectory() +"SchemaExercice.sql", baseExo);
		ssql.execute(sosi.getDatabaseDirectory() +"InitExercice.sql", baseExo);		
		
		// cration du rpertoire pour le stockage des photos des articles
		FileManager.createDirectory(sosi.getPhotosArticlesDirectory() + dossierId);		

		PreparedStatement psNewExercice = con.prepareStatement("insert into "+ baseDossier +".EXERCICE (Num_Exercice, Debut_Exercice, Fin_Exercice, Duree_Exercice, Nom_Base) values (?,?,?,?,?)");
		
		psNewExercice.setInt(1, 0);
		psNewExercice.setLong(2, debutExercice);
		psNewExercice.setLong(3, finExercice);
		psNewExercice.setInt(4, DateTime.gapInMonths(debutExercice, finExercice));
		psNewExercice.setString(5, baseExo);
		
		psNewExercice.executeUpdate();
		
		// insertion des priodes d'exercice dans le premier exercice		
		
		PeriodeExercice periodeExercice = new PeriodeExercice();
		DBM_PeriodeExercice dbmPeriodeExercice = new DBM_PeriodeExercice(con, baseExo);
		
		String []tPeriodes = new org.opensi.util.PeriodesExo(debutExercice, finExercice).getPeriodes().split(",");

		for (int i=0; i<tPeriodes.length; i++) {
			periodeExercice.setPeriode(Long.parseLong(tPeriodes[i]));
			dbmPeriodeExercice.insert(periodeExercice);
		}		

		Dossier dossier = new Dossier();
		
		dossier.setDossierId(dossierId);
		dossier.setNom(nomDossier);
		dossier.setBase(baseDossier);
		
		DBM_Dossier dbmDossier = new DBM_Dossier(con);
		dbmDossier.save(dossier);

		DateTime dt = new DateTime();
		dt.setDay(dt.currentMaxDay());
		
		ParamDossier paramDossier = new ParamDossier();
		
		paramDossier.setDateFactu(dt.getDateInMillis());		
		paramDossier.setComFact("");
		paramDossier.setComBL("");
		paramDossier.setComDevis("");
		paramDossier.setModeleEtiquette("STD01");
		paramDossier.setModelePdfFC("STD01");
		paramDossier.setModelePdfAC("STD01");
		paramDossier.setModelePdfCC("STD01");
		paramDossier.setModelePdfFF("STD01");
		paramDossier.setModelePdfAF("STD01");
		paramDossier.setModelePdfCF("STD01");
		paramDossier.setModelePdfBL("STD01");
		paramDossier.setModelePdfBP("STD01");
		paramDossier.setModelePdfBR("STD01");
		paramDossier.setModelePdfDC("STD01");
		paramDossier.setModelePdfRC("STD01");
		paramDossier.setModelePdfFAC("STD01");
		paramDossier.setCodeJournalAchat("AC");
		paramDossier.setCodeJournalVente("VE");
		paramDossier.setCodeJournalAN("AN");
		paramDossier.setNumeroCompteClients("01000000");
		paramDossier.setNumeroCompteFournisseurs("08000000");
		paramDossier.setNumeroCompteAchatUE("60700000");
		paramDossier.setNumeroCompteAchatI("60700000");
		paramDossier.setNumeroComptePortAC("62410000");
		paramDossier.setNumeroComptePortVE("70850000");
		paramDossier.setNumeroCompteEscompteAC("76500000");
		paramDossier.setNumeroCompteEscompteVE("66500000");
		paramDossier.setNumeroCompteAcompteVE("41910000");
		paramDossier.setNumeroCompteRegulAC("75800000");
		paramDossier.setNumeroCompteRegulVE("65800000");
		paramDossier.setNumeroCompteTvaDueIC("44520000");
		paramDossier.setNumeroCompteTvaDedIC("44566400");
		paramDossier.setNumeroCompteEspeces("58000000");		
		
		DBM_ParamDossier dbmParamDossier = new DBM_ParamDossier(con, baseDossier);
		dbmParamDossier.save(paramDossier);

		// droit sur le dossier pour l'utilisateur root
		PreparedStatement psNewUtilDossier = con.prepareStatement("insert into UTILISATEUR_DOSSIER (Utilisateur_Id, Dossier_Id, Acc_Config, Acc_Compta, Acc_Gest_Com, Acc_Gest_Web) values ((select Utilisateur_Id from UTILISATEUR where Login='root'),?,1,1,1,1)");
		psNewUtilDossier.setString(1, dossierId);
		psNewUtilDossier.executeUpdate();
		psNewUtilDossier.close();

		// droit sur le dossier pour l'entreprise root
		PreparedStatement psNewEntDossier = con.prepareStatement("insert into ENTREPRISE_DOSSIER (Entreprise_Id, Dossier_Id) values (1,?)");
		psNewEntDossier.setString(1, dossierId);
		psNewEntDossier.executeUpdate();
		psNewEntDossier.close();
	}
		

} // fin CreateDossier

