/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class ESHashtable {
    Hashtable h_ = null;
    Vector v_ = new Vector();

    public ESHashtable() {
        this.h_ = new Hashtable();
    }

    public void put(Object key, Object val) {
        Integer pos = (Integer)this.h_.get(key);
        if (pos == null) {
            this.v_.addElement(val);
            this.h_.put(key, new Integer(this.v_.size() - 1));
        } else {
            this.v_.setElementAt(val, pos);
        }
    }

    public void putAfter(Object before, Object key, Object val) {
        if (before == null || this.get(key) != null) {
            this.put(key, val);
            return;
        }
        Integer bpos = (Integer)this.h_.get(before);
        if (bpos == null) {
            this.put(key, val);
        } else {
            this.insertElementAt(key, val, bpos + 1);
        }
    }

    public int getIndex(Object key) {
        Integer idx = (Integer)this.h_.get(key);
        return idx == null ? -1 : idx;
    }

    public void insertElementAt(Object key, Object val, int index) throws ArrayIndexOutOfBoundsException {
        this.v_.insertElementAt(val, index);
        this.shiftH(index, 1);
        this.h_.put(key, new Integer(index));
    }

    public Object get(Object key) {
        Integer pos = (Integer)this.h_.get(key);
        if (pos == null) {
            return null;
        }
        return this.v_.elementAt(pos);
    }

    public Object remove(Object key) {
        Integer pos = (Integer)this.h_.remove(key);
        if (pos == null) {
            return null;
        }
        int at = pos;
        this.shiftH(at, -1);
        Object ret = this.v_.elementAt(at);
        this.v_.removeElementAt(at);
        return ret;
    }

    private void shiftH(int startindex, int shift) {
        Enumeration e = this.h_.keys();
        while (e.hasMoreElements()) {
            Object k = e.nextElement();
            int p = (Integer)this.h_.get(k);
            if (p < startindex) continue;
            this.h_.put(k, new Integer(p + shift));
        }
    }

    public Set keySet() {
        return this.h_.keySet();
    }

    public int size() {
        return this.v_.size();
    }

    public void clear() {
        this.h_.clear();
        this.v_.clear();
    }

    public Object elementAt(int pos) {
        return this.v_.elementAt(pos);
    }

    public Enumeration elements() {
        return this.v_.elements();
    }

    public Hashtable toHashtable() {
        return this.h_;
    }
}

