/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.util;

import java.io.File;
import java.sql.SQLException;
import org.experlog.openeas.api.DataObject;
import org.experlog.openeas.api.DataSet;
import org.experlog.util.ESSimpleDataTuple;

public class ESFileDataSet
implements DataSet {
    private File[] lst_;
    private int pos_ = 0;
    int low_ = 0;
    int high_ = -1;

    public ESFileDataSet(File input, String fnm) throws SQLException {
        String p;
        File tmp = new File(fnm);
        File f = tmp.isAbsolute() ? tmp : ((p = input.getParent()) == null ? tmp : (p.endsWith(File.separator) ? new File(p + tmp) : new File(p + File.separatorChar + tmp)));
        if (!f.exists()) {
            throw new SQLException(fnm + ": No such file or directory");
        }
        if (!f.isDirectory()) {
            throw new SQLException(fnm + " is not a valid directory");
        }
        this.lst_ = f.listFiles();
        if (this.lst_ == null || this.lst_.length <= 0) {
            this.lst_ = null;
        }
    }

    public boolean next() throws SQLException {
        return this.dataAvailable();
    }

    public boolean dataAvailable() throws SQLException {
        if (this.lst_ == null || this.high_ >= this.low_ && this.pos_ >= this.high_) {
            return false;
        }
        return this.pos_ < this.lst_.length;
    }

    public DataObject getTuple() throws SQLException {
        if (!this.dataAvailable()) {
            throw new SQLException("No more data available");
        }
        ESSimpleDataTuple dt = new ESSimpleDataTuple();
        File ff = this.lst_[this.pos_++];
        String fnm = ff.getName();
        dt.put("name", fnm);
        int pos = fnm.indexOf(46);
        if (pos >= 0) {
            dt.put("ext", fnm.substring(pos + 1));
        } else {
            dt.put("ext", "");
        }
        dt.put("isfile", ff.isFile() ? "1" : "0");
        dt.put("lastmodified", Long.toString(ff.lastModified()));
        return dt;
    }

    public void open() throws SQLException {
    }

    public void close() throws SQLException {
    }

    public boolean isTransient() {
        return true;
    }

    public void setBoundaries(int low, int high) throws SQLException {
        if (low <= 0) {
            low = 1;
        }
        this.low_ = low - 1;
        this.high_ = high;
        while (this.pos_ < this.low_ && this.next()) {
            ++this.pos_;
        }
    }
}

