/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.lite;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.experlog.lite.DataBlock;

public class MultipartRequest {
    public static final String fEOLN = "\r\n";
    public static final String fEmptyLine = "\r\n\r\n";
    public static final String fDoubleDash = "--";
    private HttpServletRequest mRequest;
    private String mBoundary;
    private byte[] mDataBytes;
    private String mDataString;

    public static final String newString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return new String(bytes);
    }

    public MultipartRequest(HttpServletRequest request) throws ServletException {
        this(request, -1);
    }

    public MultipartRequest(HttpServletRequest request, int maxSize) throws ServletException {
        this.mRequest = request;
        if (this.getContentType().indexOf("multipart") == -1) {
            throw new ServletException("ServletException: content-type should contain \"multipart\"\nInstead content-type is: " + this.getContentType());
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream((InputStream)this.getDataInputStream());
        }
        catch (IOException ex) {
            throw new ServletException(ex.toString());
        }
        int formDataLength = this.getContentLength();
        this.mDataBytes = new byte[formDataLength];
        int bytesRead = 0;
        for (int totalBytesRead = 0; totalBytesRead < formDataLength; totalBytesRead += bytesRead) {
            try {
                bytesRead = in.read(this.mDataBytes, totalBytesRead, formDataLength - totalBytesRead);
                continue;
            }
            catch (IOException ex) {
                throw new ServletException(ex.toString());
            }
        }
        this.mDataString = MultipartRequest.newString(this.mDataBytes);
        String contentType = this.mRequest.getContentType();
        int lastIndex = contentType.lastIndexOf("=");
        this.mBoundary = contentType.substring(lastIndex + 1, contentType.length());
    }

    public ServletInputStream getDataInputStream() throws IOException {
        return this.mRequest.getInputStream();
    }

    public int getContentLength() {
        return this.mRequest.getContentLength();
    }

    public String getContentType() {
        return this.mRequest.getContentType();
    }

    public byte[] getByteContent() {
        return this.mDataBytes;
    }

    public String getBoundary() {
        return this.mBoundary;
    }

    public String getQueryString() {
        return this.mRequest.getQueryString();
    }

    public String getRemoteAddr() {
        return this.mRequest.getRemoteAddr();
    }

    public String getHeaderParameter(String name) {
        return this.mRequest.getParameter(name);
    }

    public String getMultipartHeader(String name) {
        DataBlock dblock = this.getBinaryHeaderBlock(name);
        if (dblock == null) {
            return null;
        }
        byte[] bytes = dblock.getBlock();
        return MultipartRequest.newString(bytes);
    }

    public String getMultipartValue(String name) {
        DataBlock dblock = this.getBinaryValueBlock(name);
        if (dblock == null) {
            return null;
        }
        byte[] bytes = dblock.getBlock();
        return MultipartRequest.newString(bytes);
    }

    public byte[] getFileValue(String name) {
        DataBlock db = this.getBinaryFileValue(name);
        if (db == null) {
            return null;
        }
        return db.getBlock();
    }

    public String getFileContentType(String name) {
        DataBlock db = this.getBinaryFileBlock(name);
        if (db == null) {
            return null;
        }
        return db.getContentType();
    }

    public String getFileName(String name) {
        DataBlock db = this.getBinaryFileBlock(name);
        if (db == null) {
            return null;
        }
        return db.getFileName();
    }

    public String getShortFileName(String name) {
        DataBlock db = this.getBinaryFileBlock(name);
        if (db == null) {
            return null;
        }
        return this.getShortFileName(db);
    }

    public String getParameter(String name) {
        return this.getMultipartValue(name);
    }

    public String getRequestURL() {
        return new String(this.mRequest.getRequestURL());
    }

    public String getScheme() {
        return this.mRequest.getScheme();
    }

    public boolean isSecure() {
        return this.mRequest.isSecure();
    }

    public String getServerName() {
        return this.mRequest.getServerName();
    }

    public int getServerPort() {
        return this.mRequest.getServerPort();
    }

    private DataBlock getBinaryParameterBlock(String name) {
        String find = this.mBoundary + fEOLN + "Content-Disposition: form-data; name=\"" + name + "\"";
        int index = this.mDataString.indexOf(find);
        if (index == -1) {
            return null;
        }
        int index1 = this.mDataString.indexOf("\r\n--" + this.mBoundary, index + fEOLN.length());
        if (index1 == -1) {
            return null;
        }
        int index2 = this.mDataString.indexOf(fEmptyLine, index) + fEmptyLine.length();
        if (index2 == -1 || index2 > index1) {
            return null;
        }
        index2 = this.mDataString.indexOf(fEOLN, index) + fEOLN.length();
        int uploadSize = index1 - index2;
        if (uploadSize < 0) {
            return null;
        }
        byte[] uploadBytes = new byte[uploadSize];
        for (int i = 0; i < uploadSize; ++i) {
            uploadBytes[i] = this.mDataBytes[index2 + i];
        }
        return new DataBlock(index2, index1, uploadBytes, name);
    }

    private DataBlock getBinaryHeaderBlock(String name) {
        DataBlock dataBlock = this.getBinaryParameterBlock(name);
        if (dataBlock == null) {
            return null;
        }
        String block = MultipartRequest.newString(dataBlock.getBlock());
        int index = block.indexOf(fEmptyLine) + fEmptyLine.length();
        if (index == -1) {
            return null;
        }
        byte[] bytes = new byte[index];
        for (int i = 0; i < index; ++i) {
            bytes[i] = dataBlock.getBlock()[index + i];
        }
        int from = dataBlock.getFrom();
        return new DataBlock(from, from + index, bytes, name);
    }

    private DataBlock getBinaryValueBlock(String name) {
        DataBlock dataBlock = this.getBinaryParameterBlock(name);
        if (dataBlock == null) {
            return null;
        }
        String block = MultipartRequest.newString(dataBlock.getBlock());
        int index = block.indexOf(fEmptyLine) + fEmptyLine.length();
        if (index == -1) {
            return null;
        }
        int size = block.length() - index;
        byte[] bytes = null;
        if (size > 0) {
            bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = dataBlock.getBlock()[index + i];
            }
        }
        int from = dataBlock.getFrom();
        return new DataBlock(from + index, from + size, bytes, name);
    }

    private DataBlock getBinaryFileBlock(String name) {
        String filename;
        DataBlock dataBlock = this.getBinaryParameterBlock(name);
        if (dataBlock == null) {
            return null;
        }
        String parameter = this.mDataString.substring(dataBlock.getFrom(), dataBlock.getTo());
        int index = parameter.indexOf(filename = "filename=\"");
        if (index == -1) {
            return null;
        }
        int index1 = parameter.indexOf("\"\r\n", index);
        if (index1 == -1) {
            return null;
        }
        dataBlock.setIsFileBlock(true);
        dataBlock.setFileName(parameter.substring(index + filename.length(), index1));
        String contentType = "\r\nContent-Type: ";
        index = parameter.indexOf(contentType);
        if (index != -1) {
            index1 = parameter.indexOf("\"\r\n", index);
            if (index1 != -1) {
                dataBlock.setContentType(parameter.substring(index + contentType.length(), index1));
            } else {
                dataBlock.setContentType("Content-Type: text/plain");
            }
        } else {
            dataBlock.setContentType("Content-Type: text/plain");
        }
        return dataBlock;
    }

    private DataBlock getBinaryFileHeader(String name) {
        DataBlock dataBlock = this.getBinaryFileBlock(name);
        return this.getBinaryFileHeader(dataBlock);
    }

    private DataBlock getBinaryFileHeader(DataBlock dataBlock) {
        if (dataBlock == null) {
            return null;
        }
        String block = MultipartRequest.newString(dataBlock.getBlock());
        int index = block.indexOf(fEmptyLine) + fEmptyLine.length();
        if (index == -1) {
            return null;
        }
        byte[] bytes = new byte[index];
        for (int i = 0; i < index; ++i) {
            bytes[i] = dataBlock.getBlock()[i];
        }
        int from = dataBlock.getFrom();
        DataBlock db = new DataBlock(from, from + index, bytes, dataBlock.getName());
        db.setIsFileBlock(dataBlock.isFileBlock());
        db.setFileName(dataBlock.getFileName());
        return db;
    }

    private DataBlock getBinaryFileValue(String name) {
        DataBlock dataBlock = this.getBinaryFileBlock(name);
        return this.getBinaryFileValue(dataBlock);
    }

    private DataBlock getBinaryFileValue(DataBlock dataBlock) {
        if (dataBlock == null) {
            return null;
        }
        String block = MultipartRequest.newString(dataBlock.getBlock());
        int index = block.indexOf(fEmptyLine) + fEmptyLine.length();
        if (index == -1) {
            return null;
        }
        byte[] bytes = null;
        int size = block.length() - index;
        if (size > 0) {
            bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = dataBlock.getBlock()[index + i];
            }
        }
        int from = dataBlock.getFrom();
        DataBlock db = new DataBlock(from + index, from + size, bytes, dataBlock.getName());
        db.setIsFileBlock(dataBlock.isFileBlock());
        db.setFileName(dataBlock.getFileName());
        return db;
    }

    private String getShortFileName(DataBlock dataBlock) {
        String name = dataBlock.getFileName();
        if (name == null) {
            return "";
        }
        int index = name.lastIndexOf("/");
        if (index == -1 && (index = name.lastIndexOf("\\")) == -1) {
            return name;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1, name.length());
    }
}

