/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.experlog.base.OpenClient;
import org.experlog.db.Cdata;

public class ESPersistentHashtable {
    private String dbtable_ = "ESHashtable";
    private String tabId_ = "default";
    private OpenClient session_ = null;
    private boolean cache_ = true;
    private String datasource_ = null;
    private boolean singleApp_ = false;
    private Hashtable tuple_ = null;

    public ESPersistentHashtable(OpenClient session, String dsn, String tabid, String tabname) {
        this.session_ = session;
        this.datasource_ = dsn;
        if (tabname != null) {
            this.dbtable_ = tabname;
        }
        if (tabid != null) {
            this.tabId_ = tabid;
        } else if (session != null) {
            this.tabId_ = session.getClientId();
            try {
                this.cache_ = !"false".equalsIgnoreCase(session.getAppConfiguration().get("app.persist.cache"));
                this.singleApp_ = "true".equalsIgnoreCase(session.getAppConfiguration().get("app.persist.single"));
            }
            catch (Exception ignore) {
                this.cache_ = true;
                this.singleApp_ = false;
            }
        }
        if (this.cache_) {
            this.populateTuple(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateTuple(boolean force) {
        if (this.session_ != null) {
            if (!force && this.singleApp_ && this.tuple_ != null) {
                return;
            }
            if (force) {
                this.tuple_ = null;
            }
            Connection c = null;
            try {
                c = this.session_.getConnection(this.datasource_);
                Statement st = c.createStatement();
                ResultSet rs = st.executeQuery("select ckey,cvalue,wversion from " + this.dbtable_ + " where tabid='" + this.tabId_ + "'");
                while (rs.next()) {
                    if (this.tuple_ == null) {
                        this.tuple_ = new Hashtable(16);
                    }
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(rs.getBytes(2)));
                    if (this.tuple_ == null) {
                        this.tuple_ = new Hashtable(16);
                    }
                    this.tuple_.put(rs.getString(1), new Cdata(in.readObject(), rs.getLong(3)));
                    in.close();
                }
                rs.close();
                st.close();
            }
            catch (Exception e) {
                if (this.tuple_ != null && this.tuple_.size() <= 0) {
                    this.tuple_ = null;
                }
                e.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    try {
                        this.session_.closeConnection(c, this.datasource_);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object val) throws SQLException {
        if (this.tuple_ == null) {
            this.tuple_ = new Hashtable();
        }
        long wtime = System.currentTimeMillis();
        if (this.session_ != null) {
            OpenClient openClient = this.session_;
            synchronized (openClient) {
                Connection c = null;
                try {
                    c = this.session_.getConnection(this.datasource_);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bos);
                    out.writeObject(val);
                    out.close();
                    byte[] ser = bos.toByteArray();
                    PreparedStatement st = null;
                    st = this.cache_ && this.tuple_.get(key) != null ? c.prepareStatement("update " + this.dbtable_ + " set cvalue=?,wversion=wversion+1,wtime=" + wtime + " where tabid='" + this.tabId_ + "' and ckey='" + this.session_.sqlEncode(this.datasource_, key) + "'") : c.prepareStatement("insert into " + this.dbtable_ + "(tabid,ckey,cvalue,wversion,wtime) VALUES('" + this.tabId_ + "'," + "'" + this.session_.sqlEncode(this.datasource_, key) + "'," + "?," + "1," + wtime + ")");
                    try {
                        st.setBytes(1, ser);
                        st.executeUpdate();
                        st.close();
                    }
                    catch (SQLException e) {
                        if (st != null) {
                            try {
                                st.close();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                        st = c.prepareStatement("update " + this.dbtable_ + " set cvalue=?,wversion=wversion+5,wtime=" + wtime + " where tabid='" + this.tabId_ + "' and ckey='" + this.session_.sqlEncode(this.datasource_, key) + "'");
                        st.setBytes(1, ser);
                        st.executeUpdate();
                        st.close();
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new SQLException(e.getClass() + ": " + e.getMessage());
                }
                finally {
                    if (c != null) {
                        try {
                            this.session_.closeConnection(c, this.datasource_);
                        }
                        catch (Exception ignore) {}
                    }
                }
            }
        }
        this.tuple_.put(key, new Cdata(val, 0L));
    }

    public void putNoPersist(String key, Object val) {
        if (this.tuple_ == null) {
            this.tuple_ = new Hashtable();
        }
        this.tuple_.put(key, new Cdata(val, -1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) throws SQLException {
        Object ret;
        long version = 0L;
        if (this.cache_ && this.tuple_ == null) {
            this.populateTuple(false);
            if (this.tuple_ == null) {
                return null;
            }
        }
        Cdata data = this.tuple_ == null ? null : (Cdata)this.tuple_.get(key);
        Object object = ret = data == null ? null : data.value();
        if (data != null && data.version() == -1L) {
            return data.value();
        }
        if (this.session_ != null) {
            version = data == null ? 0L : data.version();
            Connection c = null;
            try {
                c = this.session_.getConnection(this.datasource_);
                Statement st = c.createStatement();
                ResultSet rs = st.executeQuery("select cvalue,wversion from " + this.dbtable_ + " where tabid='" + this.tabId_ + "' and ckey='" + this.session_.sqlEncode(this.datasource_, key) + "'" + (this.cache_ ? " and wversion>" + version : ""));
                if (rs.next()) {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(rs.getBytes(1)));
                    ret = in.readObject();
                    in.close();
                    if (this.cache_) {
                        this.tuple_.put(key, new Cdata(ret, rs.getLong(2)));
                    }
                }
                rs.close();
                st.close();
            }
            catch (Exception ignore) {
                ignore.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    try {
                        this.session_.closeConnection(c, this.datasource_);
                    }
                    catch (Exception ee) {}
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration keys() {
        if (this.cache_ || this.session_ == null) {
            if (this.tuple_ == null) {
                return null;
            }
            return this.tuple_.keys();
        }
        Connection c = null;
        Vector<String> v = null;
        try {
            c = this.session_.getConnection(this.datasource_);
            Statement st = c.createStatement();
            ResultSet rs = st.executeQuery("select ckey from " + this.dbtable_ + " where tabid='" + this.tabId_);
            while (rs.next()) {
                if (v == null) {
                    v = new Vector<String>();
                }
                v.addElement(rs.getString(1));
            }
            rs.close();
            st.close();
        }
        catch (Exception ignore) {
            ignore.printStackTrace(System.err);
        }
        finally {
            if (c != null) {
                try {
                    this.session_.closeConnection(c, this.datasource_);
                }
                catch (Exception exception) {}
            }
        }
        return v == null ? null : v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) throws SQLException {
        if (this.cache_ && this.tuple_ == null) {
            return;
        }
        if (this.session_ != null) {
            Connection c = null;
            try {
                c = this.session_.getConnection(this.datasource_);
                Statement st = c.createStatement();
                st.executeUpdate("delete from " + this.dbtable_ + " where tabid='" + this.tabId_ + "' and ckey='" + this.session_.sqlEncode(this.datasource_, key) + "'");
                st.close();
            }
            catch (Exception ignore) {
                ignore.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    try {
                        this.session_.closeConnection(c, this.datasource_);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (this.tuple_ != null) {
            this.tuple_.remove(key);
        }
    }

    public void clear() {
        if (this.tuple_ != null) {
            this.tuple_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(int days) {
        if (this.session_ != null) {
            Connection c = null;
            try {
                c = this.session_.getConnection(this.datasource_);
                Statement st = c.createStatement();
                long old = System.currentTimeMillis() - (long)days * 24L * 3600L * 1000L;
                st.executeUpdate("delete from " + this.dbtable_ + " where wtime<" + old + " and tabid='" + this.tabId_ + "'");
                st.close();
            }
            catch (Exception ignore) {
                ignore.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    try {
                        this.session_.closeConnection(c, this.datasource_);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public Hashtable toHashtable() {
        if (!this.cache_) {
            this.populateTuple(true);
        }
        return this.tuple_;
    }

    public void fromHashtable(Hashtable t) throws SQLException {
        this.clear();
        Enumeration keys = t.keys();
        while (keys.hasMoreElements()) {
            String k = (String)keys.nextElement();
            this.put(k, t.get(k));
        }
    }
}

