/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.experlog.base.ESServletRequest;
import org.experlog.base.OpenClient;
import org.experlog.db.ESColumn;
import org.experlog.openeas.api.DataObject;
import org.experlog.util.ESDbMapper;

public class ESDbObject
implements DataObject {
    protected OpenClient session_ = null;
    String origtable_ = null;
    String dbtable_ = null;
    boolean changed_ = false;
    boolean sqlencode_ = true;
    Hashtable tuple_ = new Hashtable();
    boolean casesensitive_ = false;
    String datasource_ = null;
    protected ESDbMapper map_ = null;

    public ESDbObject() {
    }

    public ESDbObject(String table, String qry, OpenClient session) throws SQLException {
        this(table, qry, session, null);
    }

    public ESDbObject(String table, String qry, OpenClient session, String dsn) throws SQLException {
        if (session == null || table == null || qry == null) {
            throw new SQLException("ESDbObject: init error - null parameter");
        }
        this.datasource_ = dsn;
        ResultSet rs = null;
        Connection c = null;
        Statement st = null;
        try {
            c = session.getConnection(this.datasource_);
            st = c.createStatement();
            session.logRequest(null, qry);
            rs = st.executeQuery(qry);
            if (!rs.next()) {
                throw new SQLException("ESDbObject: init error - object not found in database");
            }
            String cs = session.getAppConfiguration().get("jdbc.CaseSensitive");
            if (cs != null) {
                this.casesensitive_ = cs.trim().equalsIgnoreCase("true");
            }
            try {
                this.initialize(c, table, rs);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {}
            }
            if (st != null) {
                st.close();
            }
            session.closeConnection(c, this.datasource_);
        }
    }

    public ESDbObject(OpenClient session, String table, ResultSet rs) throws SQLException {
        this(session, table, rs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ESDbObject(OpenClient session, String table, ResultSet rs, String dsn) throws SQLException {
        this.datasource_ = dsn;
        if (session != null) {
            this.map_ = session.getDbMapper();
            this.session_ = session;
            String cs = session.getAppConfiguration().get("jdbc.CaseSensitive");
            if (cs != null) {
                this.casesensitive_ = cs.trim().equalsIgnoreCase("true");
            }
            Connection con = null;
            try {
                con = rs == null ? session.getConnection(this.datasource_) : null;
                this.initialize(con, table, rs);
                if (con == null) return;
                session.closeConnection(con, this.datasource_);
                return;
            }
            catch (Exception e) {
                return;
            }
            finally {
                if (con != null) {
                    session.closeConnection(con, this.datasource_);
                }
            }
        } else {
            this.initialize(null, table, rs);
        }
    }

    String adaptCase(String s) {
        return this.casesensitive_ ? s : s.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Connection conn, String table, ResultSet rs) throws SQLException {
        boolean internal;
        this.origtable_ = table;
        this.dbtable_ = this.map_ != null ? this.map_.getTable(this.origtable_) : this.origtable_;
        String colname = null;
        int coltype = 0;
        boolean bl = internal = rs == null && conn != null;
        if (internal) {
            try {
                DatabaseMetaData md = conn.getMetaData();
                ResultSet rsc = md.getColumns("", "", this.dbtable_, "%");
                while (rsc.next()) {
                    colname = rsc.getString(4);
                    coltype = rsc.getInt(5);
                    this.tuple_.put(this.adaptCase(colname), new ESColumn(ESColumn.isNumeric(coltype) ? "0" : "", coltype, true));
                }
                rsc.close();
            }
            catch (Exception ee) {
                Statement st = null;
                try {
                    st = conn.createStatement();
                    try {
                        rs = st.executeQuery("select * from " + this.dbtable_ + " limit 1");
                    }
                    catch (Exception rse) {
                        rs = st.executeQuery("select * from " + this.dbtable_);
                    }
                    ResultSetMetaData md = rs.getMetaData();
                    for (int i = 1; i <= md.getColumnCount(); ++i) {
                        colname = md.getColumnName(i);
                        coltype = md.getColumnType(i);
                        this.tuple_.put(this.adaptCase(colname), new ESColumn(ESColumn.isNumeric(coltype) ? "0" : "", coltype, md.isWritable(i)));
                    }
                }
                catch (Exception ignore) {
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                }
            }
        } else if (rs != null) {
            ResultSetMetaData md = rs.getMetaData();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                colname = md.getColumnName(i);
                coltype = md.getColumnType(i);
                this.tuple_.put(this.adaptCase(colname), new ESColumn(rs.getString(i), coltype, md.isWritable(i)));
            }
        }
    }

    public void setSqlEncode(boolean s) {
        this.sqlencode_ = s;
    }

    public void setWritable(String name, boolean w) {
        ESColumn col;
        if (this.map_ != null) {
            name = this.map_.getField(this.origtable_, name);
        }
        if ((col = (ESColumn)this.tuple_.get(this.adaptCase(name))) != null) {
            col.setWritable(w);
        }
    }

    private final String internal_get(String name) throws SQLException {
        ESColumn col;
        if (this.map_ != null) {
            name = this.map_.getField(this.origtable_, name);
        }
        if ((col = (ESColumn)this.tuple_.get(this.adaptCase(name))) == null) {
            return null;
        }
        return col.getString();
    }

    public String get(String name) throws SQLException {
        return this.internal_get(name);
    }

    public void set(String name, String val) {
        ESColumn col;
        if (this.map_ != null) {
            name = this.map_.getField(this.origtable_, name);
        }
        if ((col = (ESColumn)this.tuple_.get(this.adaptCase(name))) != null && col.isWritable()) {
            if (this.sqlencode_) {
                val = this.sqlEncode(val);
            }
            col.set(val);
            this.tuple_.put(this.adaptCase(name), col);
            if (col.valueChanged()) {
                this.changed_ = true;
            }
        }
    }

    public void set(String name, int val) {
        this.set(name, Integer.toString(val));
    }

    public void set(String name, long val) {
        this.set(name, Long.toString(val));
    }

    public void set(String name, double val) {
        this.set(name, Double.toString(val));
    }

    public double getDouble(String name) throws SQLException {
        String v = this.internal_get(name);
        if (v == null) {
            throw new SQLException("No such column: " + name);
        }
        try {
            return Double.valueOf(v);
        }
        catch (NumberFormatException e) {
            throw new SQLException("Double number format exception: " + v);
        }
    }

    public boolean present(String col) {
        if (this.map_ != null) {
            col = this.map_.getField(this.origtable_, col);
        }
        return this.tuple_.get(this.adaptCase(col)) != null;
    }

    public Enumeration keys() {
        return this.tuple_ == null ? null : this.tuple_.keys();
    }

    public void setFromRequest(ESServletRequest req) {
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String pname = (String)en.nextElement();
            if (!this.present(pname)) continue;
            this.set(pname, req.getParameter(pname));
        }
    }

    public void addColumn(String name, int type, String val) {
        if (this.tuple_.get(this.adaptCase(name)) == null) {
            this.tuple_.put(this.adaptCase(name), new ESColumn(val, type, true));
        }
    }

    public void saveChanges(String where) throws SQLException {
        if (!this.changed_) {
            return;
        }
        String sql = this.updateQuery(where);
        if (sql != null) {
            Connection con = null;
            try {
                con = this.session_.getConnection(this.datasource_);
                Statement st = con.createStatement();
                this.session_.logRequest(null, sql);
                st.executeUpdate(sql);
                st.close();
                this.session_.closeConnection(con, this.datasource_);
                con = null;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
            finally {
                if (con != null) {
                    try {
                        this.session_.closeConnection(con, this.datasource_);
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    public void clearValues() {
        Enumeration en = this.tuple_.keys();
        while (en.hasMoreElements()) {
            String colname = (String)en.nextElement();
            ESColumn col = (ESColumn)this.tuple_.get(colname);
            if (col.isNumeric()) {
                this.set(colname, "0");
                continue;
            }
            this.set(colname, "");
        }
    }

    String sqlEncode(String s) {
        if (s == null) {
            return null;
        }
        String sep = null;
        String rules = null;
        try {
            if (this.session_ != null) {
                sep = this.session_.getAppConfiguration().get("sqlencode.Separator");
            }
        }
        catch (SQLException e) {
            sep = null;
        }
        if (sep == null) {
            sep = ";";
        }
        try {
            if (this.session_ != null) {
                rules = this.session_.getAppConfiguration().get("sqlencode.Substitutions");
            }
        }
        catch (SQLException e) {
            rules = null;
        }
        if (rules == null) {
            rules = "'='';\r=\" \";\n=\" \";";
        }
        StringTokenizer st = new StringTokenizer(rules, sep);
        Hashtable<String, String> subst = new Hashtable<String, String>();
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
            if (!st2.hasMoreTokens()) continue;
            String k = st2.nextToken();
            if (!st2.hasMoreTokens()) continue;
            String v = st2.nextToken();
            if (v.equals("\" \"")) {
                v = " ";
            } else if (v.equals("\"\"")) {
                v = "";
            }
            subst.put(k, v);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String sub = (String)subst.get(String.valueOf(c));
            if (sub == null) {
                buf.append(c);
                continue;
            }
            buf.append(sub.toString());
        }
        return buf.toString();
    }

    public String toString() {
        return this.tuple_ == null ? "null" : this.tuple_.toString();
    }

    public String deleteQuery(String where) {
        if (where == null || where.length() < 1) {
            return "DELETE FROM " + this.dbtable_;
        }
        return "DELETE FROM " + this.dbtable_ + " WHERE " + where;
    }

    public String updateQuery(String where) {
        if (!this.changed_) {
            return null;
        }
        StringBuffer sql = new StringBuffer("UPDATE " + this.dbtable_ + " SET");
        Enumeration en = this.tuple_.keys();
        boolean first = true;
        while (en.hasMoreElements()) {
            String colname = (String)en.nextElement();
            ESColumn col = (ESColumn)this.tuple_.get(colname);
            if (!col.isWritable() || !col.valueChanged()) continue;
            boolean quote = !col.isNumeric();
            sql.append((first ? " " : ",") + colname + "=" + (quote ? "'" : "") + col.getString() + (quote ? "'" : ""));
            first = false;
        }
        if (where != null && where.length() >= 1) {
            sql.append(" WHERE " + where);
        }
        return sql.toString();
    }

    public String insertQuery() {
        String colname;
        StringBuffer sql = new StringBuffer("INSERT INTO " + this.dbtable_ + "(");
        Enumeration en = this.tuple_.keys();
        boolean first = true;
        while (en.hasMoreElements()) {
            colname = (String)en.nextElement();
            sql.append((first ? "" : ",") + colname);
            first = false;
        }
        sql.append(") VALUES (");
        en = this.tuple_.keys();
        first = true;
        while (en.hasMoreElements()) {
            colname = (String)en.nextElement();
            ESColumn col = (ESColumn)this.tuple_.get(colname);
            boolean quote = !col.isNumeric();
            sql.append((first ? "" : ",") + (quote ? "'" : "") + col.getString() + (quote ? "'" : ""));
            first = false;
        }
        sql.append(")");
        return sql.toString();
    }

    public static void main(String[] args) {
        try {
            ESDbObject dbo = new ESDbObject(null, "ECustomer", (ResultSet)null);
            dbo.addColumn("Id", 12, "001");
            dbo.setWritable("Id", false);
            dbo.addColumn("FirstName", 12, "Bill");
            dbo.addColumn("LastName", 12, "Smith");
            dbo.addColumn("Age", 4, "30");
            dbo.set("FirstName", "John");
            System.out.println(dbo.updateQuery("Id='001'"));
            System.out.println(dbo.insertQuery());
            System.out.println(dbo.deleteQuery(null));
        }
        catch (Exception e) {
            System.err.println("ESDbObject:main Exception " + e);
        }
    }
}

