/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.SQLBuilder;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.enhydra.instantdb.SQLBuilder.SQLBuilder;

class ConnectionPanel
extends JPanel {
    static String[] drivers = new String[]{"org.enhydra.instantdb.jdbc.idbDriver", "sun.jdbc.odbc.JdbcOdbcDriver"};
    JComboBox driverList;
    JTextField urlText;
    JTextField userText;
    JTextField passText;
    JButton browseButton;
    JButton connectButton;
    ActionListener buttonHandler;
    JFrame applicationFrame;
    JLabel statusBar;
    Connection con;
    SQLBuilder parent;

    ConnectionPanel(SQLBuilder sQLBuilder) {
        this.parent = sQLBuilder;
        this.applicationFrame = this.parent.getFrame();
        this.statusBar = this.parent.getStatusBar();
        this.driverList = new JComboBox();
        int n = 0;
        while (n < drivers.length) {
            this.driverList.addItem(drivers[n]);
            ++n;
        }
        this.setLayout(null);
        JLabel jLabel = new JLabel("Driver");
        this.add(jLabel);
        jLabel.setBounds(50, 50, 80, 20);
        this.add(this.driverList);
        this.driverList.setBounds(140, 50, 150, 20);
        this.urlText = this.addLabelledTextBox("URL", 80);
        this.userText = this.addLabelledTextBox("Username", 100);
        this.passText = this.addLabelledTextBox("Password", 120);
        this.buttonHandler = new ButtonListener();
        this.browseButton = this.addButton("Browse", 100);
        this.connectButton = this.addButton("Connect", 210);
        this.setSize(250, 120);
    }

    JButton addButton(String string, int n) {
        JButton jButton = new JButton(string);
        this.add(jButton);
        jButton.setBounds(n, 170, 100, 30);
        jButton.addActionListener(this.buttonHandler);
        return jButton;
    }

    JTextField addLabelledTextBox(String string, int n) {
        JLabel jLabel = new JLabel(string);
        this.add(jLabel);
        jLabel.setBounds(50, n, 80, 20);
        JTextField jTextField = null;
        jTextField = string.equals("Password") ? new JPasswordField() : new JTextField();
        this.add(jTextField);
        jTextField.setBounds(140, n, 150, 20);
        return jTextField;
    }

    void onDisconnect() throws SQLException {
        if (this.con != null) {
            this.statusBar.setText("Disconnecting...");
            this.con.close();
            this.con = null;
            this.connectButton.setText("Connect");
            this.statusBar.setText("Disconnected");
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                if (actionEvent.getSource() == ConnectionPanel.this.browseButton) {
                    FileDialog fileDialog = new FileDialog((Frame)ConnectionPanel.this.applicationFrame, "Browse Database", 0);
                    fileDialog.show();
                    ConnectionPanel.this.urlText.setText("jdbc:idb:" + fileDialog.getDirectory() + fileDialog.getFile());
                } else {
                    String string = ConnectionPanel.this.statusBar.getText();
                    try {
                        if (ConnectionPanel.this.con == null) {
                            ConnectionPanel.this.statusBar.setText("Connecting...");
                            ConnectionPanel.this.statusBar.paintImmediately(0, 0, 1000, 30);
                            String string2 = (String)ConnectionPanel.this.driverList.getSelectedItem();
                            Class.forName(string2).newInstance();
                            ConnectionPanel.this.con = ConnectionPanel.this.userText.getText().equals("") ? DriverManager.getConnection(ConnectionPanel.this.urlText.getText()) : DriverManager.getConnection(ConnectionPanel.this.urlText.getText(), ConnectionPanel.this.userText.getText(), ConnectionPanel.this.passText.getText());
                            ConnectionPanel.this.parent.onConnect(ConnectionPanel.this.con);
                            ConnectionPanel.this.connectButton.setText("Disconnect");
                            ConnectionPanel.this.statusBar.setText("Connected to " + ConnectionPanel.this.urlText.getText());
                            break block5;
                        }
                        ConnectionPanel.this.onDisconnect();
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, exception.toString(), "Error", -1);
                        ConnectionPanel.this.statusBar.setText(string);
                    }
                }
            }
        }
    }
}

